(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    150228,       4296]*)
(*NotebookOutlinePosition[    151889,       4346]*)
(*  CellTagsIndexPosition[    151785,       4339]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Elementos de programaci\[OAcute]n con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Title"],

Cell[TextData[StyleBox["Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez\n\
Departamento de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada",
  FontSize->12]], "Author",
  TextAlignment->Left],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell[TextData[{
  StyleBox[
  "Las expresiones que escribes para que un ordenador realice una determinada \
tarea consituyen un ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["programa",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" y reciben el nombre de ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["c\[OAcute]digo fuente. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["Lo primero que necesitas para escribir un programa es un ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["lenguaje de programaci\[OAcute]n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " que te permita comunicarte con el ordenador. Hay muchos lenguajes de \
programaci\[OAcute]n con diferencias notables entre ellos. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " tiene su propio lenguaje de programaci\[OAcute]n: es el que usas cuando \
escribes comandos y expresiones que pueden ser ejecutados en una celda de \
input. Los ordenadores no entienden el c\[OAcute]digo fuente escrito en \
ninguno de los lenguajes de programaci\[OAcute]n usuales, dicho \
c\[OAcute]digo debe ser traducido a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["c\[OAcute]digo m\[AAcute]quina",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " que es el \[UAcute]nico que entiende un microprocesador como el que tiene \
el ordenador que est\[AAcute]s usando. \nLos lenguajes de \
programaci\[OAcute]n se dividen en dos grandes categor\[IAcute]as dependiendo \
de la forma en que se haga la conversi\[OAcute]n de c\[OAcute]digo fuente a c\
\[OAcute]digo m\[AAcute]quina. Cuando \[EAcute]sta debe hacerse (una sola \
vez), ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["antes",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" de ejecutar el programa en el ordenador, por medio de un ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["compilador",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " que realiza la conversi\[OAcute]n y produce un archivo que contiene el c\
\[OAcute]digo m\[AAcute]quina el cual podr\[AAcute] ser ejecutado \
posteriormente sin necesidad de nueva conversi\[OAcute]n, se dice que se \
trata de un ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["lenguaje compilado",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". Lenguajes como C, Fortran o Pascal son lenguajes compilados. Cuando la \
conversi\[OAcute]n debe hacerse sobre la marcha ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["al mismo tiempo",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " que se ejecuta el programa (y cada vez que se ejecuta el programa), se \
dice que se trata de un ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["lenguaje interpretado",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". Puesto que la conversi\[OAcute]n requiere un tiempo, los lenguajes \
compilados son mucho m\[AAcute]s r\[AAcute]pidos que los interpretados. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " es un lenguaje interpretado aunque dispone de recursos que permiten \
\"compilar expresiones\" y traducirlas internamente a un lenguaje \
pr\[OAcute]ximo al c\[OAcute]digo m\[AAcute]quina. Si lo piensas un poco te \
convencer\[AAcute]s de que un programa como ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " tiene que ser as\[IAcute]: \[DownQuestion]te imaginas que tuvieras que \
compilar el c\[OAcute]digo de cada celda de input antes de ejecutarla?\nUn \
mismo programa puede implementarse de muy distintas formas. En este sentido \
suelen distinguirse varios estilos de programaci\[OAcute]n (",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["paradigmas",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " de programaci\[OAcute]n) que se diferencian por la forma de organizar el \
c\[OAcute]digo fuente y en la preferencia por cierto tipo de acciones o de \
datos. Una virtud de ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " es que permite programar seg\[UAcute]n diferentes principios y \
paradigmas. \nEn esta pr\[AAcute]ctica vamos a considerar algunos aspectos \
propios de un estilo de programaci\[OAcute]n, llamado ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["programaci\[OAcute]n procedimental,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" que usa con frecuencia estructuras condicionales (\"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["If[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\", \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Which[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\", \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["While[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "\") que permiten evaluar ciertas expresiones dependiendo del resultado de \
un test, as\[IAcute] como estructuras recursivas y bucles (\"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Do[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\", \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["For[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "\"). Pascal, Fortran, C son lenguajes de programaci\[OAcute]n \
procedimental.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Lo que debes aprender en esta pr\[AAcute]ctica es lo que sigue.
Distinguir entre variables locales y globales.
Usar la estructura Module[ ] para localizar variables en un programa.
Usar los comandos If[ ], Which[ ], For[ ], While[ ], Do[ ].
Programar los m\[EAcute]todos de bisecci\[OAcute]n y de Newton-Raphson para c\
\[AAcute]lculo aproximado de soluciones de ecuaciones.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reasignaci\[OAcute]n de variables", "Section"],

Cell[TextData[{
  "En las pr\[AAcute]cticas anteriores has aprendido a usar el comando de \
asignaci\[OAcute]n \"=\" para declarar e inicializar variables. Es frecuente \
que queramos cambiar el valor de una variable por medio de una operaci\
\[OAcute]n aritm\[EAcute]tica y asignarle el nuevo valor a dicha variable. \
Podemos hacer esto usando el comando \"=\" de la misma forma que antes lo \
usamos para declarar la variable pero no debes olvidar que el lado de la \
derecha se eval\[UAcute]a ",
  StyleBox["antes",
    FontSlant->"Italic"],
  " que la nueva asignaci\[OAcute]n sea hecha. Considera la siguiente celda:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
var = 10;
var = var + 10\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "(Observa que el ; suprime la salida de la primera l\[IAcute]nea). Lo que \
ocurre en la segunda l\[IAcute]nea es que \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["var+10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\" es eval\[UAcute]ado al entero 20 el cual es asignado a \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["var",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "\".  Desde un punto de vista matem\[AAcute]tico puede parecer extra\
\[NTilde]o el uso del igual en la expresi\[OAcute]n \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["var=var+10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\" pero no olvides que \"=\" en ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " no significa \"igual\" sino que es un comando de asignaci\[OAcute]n por \
el cual se atribuye un valor a una expresi\[OAcute]n (recuerda que en ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" el doble signo \"==\" es el test de igualdad).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Aqu\[IAcute] tienes otros ejemplos:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["var = var * 2", "Input",
  AspectRatioFixed->True],

Cell["var = var / 5", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "En los bucles de programaci\[OAcute]n suelen usarse ",
  StyleBox["iteradores",
    FontSlant->"Italic"],
  " que no son sino variables que se inicializan en un valor y se van \
incrementando o decrementando hasta que alcanzan un cierto valor en cuyo \
momento el bucle se detiene.  Una expresi\[OAcute]n c\[OAcute]moda para \
incrementar una variable en una unidad es \"",
  StyleBox["++",
    FontFamily->"Courier"],
  "\". Por ejemplo \"",
  StyleBox["i++",
    FontFamily->"Courier"],
  "\" indica que se aumente el valor actual de ",
  StyleBox["i",
    FontFamily->"Courier"],
  " en una unidad. An\[AAcute]logo significado tiene \"",
  StyleBox["i--",
    FontFamily->"Courier"],
  "\". Debes tener en cuenta que el incremento (o decremento) tendr\[AAcute] \
lugar ",
  StyleBox["despu\[EAcute]s",
    FontSlant->"Italic"],
  " de que el valor actual de ",
  StyleBox["i",
    FontFamily->"Courier"],
  " se haya usado en la expresi\[OAcute]n correspondiente. "
}], "Text"],

Cell[BoxData[{
    \(var = 9\), 
    \(\(var++\)\)}], "Input"],

Cell[TextData[{
  "Aunque obtenemos 9 como valor de ",
  StyleBox["var",
    FontFamily->"Courier"],
  " su valor actual es 10."
}], "Text"],

Cell[BoxData[
    \(var\)], "Input"],

Cell[TextData[{
  "Lo que ha sucedido es que al ejecutar \"",
  StyleBox["var++",
    FontFamily->"Courier"],
  "\" el valor de esta expresi\[OAcute]n era el de ",
  StyleBox["var",
    FontFamily->"Courier"],
  ", que era 9, y ",
  StyleBox["despu\[EAcute]s",
    FontSlant->"Italic"],
  " que se hizo la evaluaci\[OAcute]n (que devolvi\[OAcute] el valor 9), ",
  StyleBox["var",
    FontFamily->"Courier"],
  " fue incrementada."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Variables locales y variables globales", "Section"],

Cell[TextData[{
  "Cada vez que declaras una variable o una funci\[OAcute]n ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " la guarda en alg\[UAcute]n ",
  StyleBox["contexto.",
    FontSlant->"Italic"],
  " Por defecto el contexto en el que se guardan todas las variables y \
funciones definidas por el usuario es el contexto ",
  StyleBox["Global",
    FontFamily->"Courier"],
  ". Esto es as\[IAcute] para que dichas variables y funciones puedan ser \
usadas en cualquier celda en cualquier momento."
}], "Text"],

Cell[BoxData[
    \(\(?var\)\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " te dice que ",
  StyleBox["var",
    FontFamily->"Courier"],
  " es una variable almacenada en el contexto ",
  StyleBox["Global",
    FontFamily->"Courier"],
  " cuyo valor actual es 10. Muchas veces es conveniente usar alguna variable \
o alguna funci\[OAcute]n para realizar una tarea muy espec\[IAcute]fica y no \
nos interesa que dicha variable o funci\[OAcute]n pueda ser accesible desde \
otras instancias del programa. Para ello ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone del comando ",
  StyleBox["Module[{",
    FontFamily->"Courier"],
  StyleBox["x", "TI",
    FontFamily->"Courier"],
  StyleBox[",", "MR",
    FontFamily->"Courier"],
  StyleBox["y", "TI",
    FontFamily->"Courier"],
  StyleBox[",...", "MR",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Courier"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula",
    FontFamily->"Courier"],
  StyleBox[",", "MR",
    FontFamily->"Courier"],
  StyleBox["expr]", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  "que especifica que los s\[IAcute]mbolos ",
  StyleBox["x, y,...",
    FontFamily->"Courier"],
  " en ",
  StyleBox["expr",
    FontFamily->"Courier"],
  " deben ser tratados como variables locales."
}], "Text"],

Cell[BoxData[
    RowBox[{\(Module[{var}, var = 0; var]\), 
      RowBox[{"(*", " ", 
        RowBox[{
        "Mathematica", " ", "nos", " ", "da", " ", "el", " ", "valor", " ", 
          "de", " ", "la", " ", 
          StyleBox["variable",
            FontSlant->"Italic"], 
          StyleBox[" ",
            FontSlant->"Italic"], 
          StyleBox["local",
            FontSlant->"Italic"], " ", "\"\<var\>\""}], " ", "*)"}]}]], 
  "Input"],

Cell[BoxData[
    \(\(var
    \  (*\ "\<var\>"\ sigue\ siendo\ una\ variable\ global\ y\ su\ valor\ no\ 
        ha\ cambiado\ *) \)\)], "Input"],

Cell["\<\
Aqu\[IAcute] tienes otro ejemplo para que entiendas la diferencia entre \
variable global y local.\
\>", "Text"],

Cell[BoxData[{
    \(t = 5; 
    \  (*\ declaramos\ "\<t\>"\ como\ variable\ global\ con\ valor\ inicial\ 5
        \ *) \nf[x_] := Module[{t}, t = \((1 + x)\)^2; Expand[t]] (*\ 
      declaramos "\<t\>" como\ una\ variable\ local\ *) \), 
    \(f[a + b]\)}], "Input"],

Cell[BoxData[
    \(\(?t\)\)], "Input"],

Cell[TextData[{
  StyleBox[
  "Observa que Module[{x,y,...}, expr ] tiene dos argumentos: las variables \
locales, {x,y,...}, y \"expr\" que es una expresi\[OAcute]n o una sucesi\
\[OAcute]n de expresiones separadas por punto y coma. Recuerda que para que ",
    
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  " realice una sucesi\[OAcute]n de operaciones y muestre en pantalla la \
\[UAcute]ltima basta con que las escribas una a continuaci\[OAcute]n de otra \
separadas por punto y coma.",
    FontWeight->"Bold"],
  " "
}], "Text"],

Cell[TextData[{
  "La localizaci\[OAcute]n de variables combinada con el operador de \
sustituci\[OAcute]n es muy \[UAcute]til para definir derivadas de forma \
segura. El operador de derivaci\[OAcute]n se escribe en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " en la forma D[funcion[variable],{variable,n}] donde \"n\" indica el orden \
de la derivada. Para n=1 basta escribir D[funcion[variable],variable]"
}], "Text"],

Cell[BoxData[{
    \(Clear[f, h]\), 
    \(f[x_] := x^2\ *\ Tan[x]\), 
    \(h[x_] := D[f[x], x]\  (*\ derivada\ de\ f[x]\ respecto\ a\ x\ *) \), 
    \(h[x]\)}], "Input"],

Cell["\<\
Todo parece correcto pero veamos lo que ocurre si intentamos evaluar la funci\
\[OAcute]n h[ ] de la forma usual.\
\>", "Text"],

Cell[BoxData[
    \(h[3]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nos dice que no se puede derivar respecto a \"3\" porque \"3\" no es una \
variable. Lo que ocurre es que al usar la asignaci\[OAcute]n diferida para \
definir la funci\[OAcute]n derivada h[ ] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no ha realizado la derivaci\[OAcute]n indicada. Comprob\[EAcute]moslo."
}], "Text"],

Cell[BoxData[
    \(\(?h\)\)], "Input"],

Cell[TextData[{
  "Por eso al escribir h[3] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sustituye en la definici\[OAcute]n de h[x] la variable \"x\" por \"3\" lo \
que lleva al mensaje de error anterior. Esto puede evitarse usando la \
asignaci\[OAcute]n directa."
}], "Text"],

Cell[BoxData[{
    \(Clear[h]\), 
    \(h[x_] = D[f[x], x]; \nh[x]\), 
    \(h[3]\)}], "Input"],

Cell["\<\
Pero una forma m\[AAcute]s segura de hacerlo es localizar la variable de \
derivaci\[OAcute]n como sigue.\
\>", "Text"],

Cell[BoxData[{
    \(Clear[f, h]\), 
    \(f[x_] := x^2\ *\ Tan[x]\), 
    \(h[x_] := Module[{s}, D[f[s], s] /. s -> x]\  (*
      localizamos\ la\ variable\ respecto\ a\ la\ cual\ derivamos\ y\ 
        despu\[EAcute]s\ la\ sustituimos\ por\ la\ variable\ x*) \), 
    \({h[x], h[3]}\), 
    \(Clear[f, h]\)}], "Input"],

Cell["\<\
Veamos otro ejemplo del uso de variables locales. Supongamos que queremos \
obtener valores de una funci\[OAcute]n que depende de un par\[AAcute]metro \
que toma valores de forma aleatoria. \
\>", "Text"],

Cell[BoxData[{
    \(a := Random[Integer, {1, 5}] (*
      a\ toma\ valores\ enteros\ comprendidos\ entre\ 1\ y\ 5\ de\ forma\ 
        aleatoria . \ Observa\ que\ no\ podemos\ usar\ la\ asignaci\[OAcute]n
        \ directa*) \), 
    \(f[x_] := a*x^2 + 7  x - a\ ;  (*
      la\ funci\[OAcute]n\ cuyo\ par\[AAcute]metro\ es\ a . \ Observa\ que\ no
        \ podemos\ usar\ la\ asignaci\[OAcute]n\ directa*) 
      \[IndentingNewLine]Table[f[x], {x, 1, 5}] // Sort\  (*
      evaluamos\ f\ en\ los\ n\[UAcute]meros\ enteros\ 1, 2, 3, 4, 5*) \), 
    \(\(Table[a*x^2 + 7  x - a, {a, 1, 5}, {x, 1, 5}] // Flatten\) // Union (*
      todos\ los\ posibles\ valores\ de\ f\ cuando\ el\ par\[AAcute]metro\ a\ 
        y\ la\ variable\ x\ toman\ los\ valores\ enteros\ 1, 2, 3, 4, 5*) 
      \)}], "Input"],

Cell[TextData[{
  "Salvo rara casualidad, podr\[AAcute]s ver que en la primera lista hay \
valores que no est\[AAcute]n en la segunda. Extra\[NTilde]o, \
\[DownQuestion]verdad? Para saber lo que est\[AAcute] pasando podemos pedir a \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que ejecute paso a paso el comando conflictivo."
}], "Text"],

Cell[BoxData[
    \(Trace[f[2]]\)], "Input"],

Cell[TextData[{
  "Procura entender lo anterior. Ahora est\[AAcute] claro lo que pasa: para \
evaluar la funci\[OAcute]n ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha llamado dos veces a la variable \"a\" asignando valores distintos en \
cada caso lo que provoca el error. Esto puede arreglarse localizando el par\
\[AAcute]metro."
}], "Text"],

Cell[BoxData[
    \(Clear[f]; \n
    valores := 
      Module[{b}, a := Random[Integer, {1, 5}]; \ \ \ \ b = a; 
        f[x_] := b*x^2 + 7  x - b; Table[f[x], {x, 1, 5}] // Sort\ ]; \n
    valores\)], "Input"],

Cell[BoxData[
    \(Clear["\<@\>"]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Evaluaci\[OAcute]n condicional ", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["If", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["El uso m\[AAcute]s frecuente del comando \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["If[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\" es con tres argumentos.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["If[test,expr1,expr2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox[
  " El primer argumento debe ser una expresi\[OAcute]n boleana. Si ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["test=True",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[",  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["expr1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" es ejecutada, mientras que si ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["test=False",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["expr2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" es ejecutada. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Las expresiones ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times New Roman"],
  StyleBox["expr1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" y ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times New Roman"],
  StyleBox["expr2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " pueden estar formadas por varias instrucciones separadas por punto y \
coma.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[TextData[{
  StyleBox["Por ejemplo, podemos usar \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["If[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "\"  para definir una funci\[OAcute]n que devuelva 1 si su argumento es \
positivo y devuelva -1 si es negativo.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Clear[f]\nf[x_] := If[x>0,1,-1] (* observa que es obligado el uso de := si \
no lo usamos ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tratar\[IAcute]a de evaluar inmediatamente la condici\[OAcute]n x>0 lo \
que dar\[IAcute]a un error *)\nf[-.2]\nf[.01]"
}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Podemos modificar la funci\[OAcute]n para que devuelva 0 si su argumento \
es igual a 0. Para ello podemos anidar dos \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["If[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\" como sigue. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Clear[f]
f[x_]:= If[x>0,1,If[x==0,0,-1]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Si el argumento es mayor que 0, \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["f[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\" devuelve un ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["; si no, si es igual a cero, devuelve un ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["0",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["; en otro caso devuelve un ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["-1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Which", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Este comando se usa cuando queremos elegir entre varias acciones posibles \
dependiendo del resultado de varios tests. En la funci\[OAcute]n antes \
definida hemos necesitado dos tests: uno para comprobar si el argumento es \
mayor que 0 y otro para comprobar si es igual a 0. En estos casos el comando \
\"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Which[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "\" es apropiado porque permite hacer todo el trabajo en una estructura \
sint\[AAcute]ctica sencilla. El comando \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Which[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "\" considera sus argumentos por pares formados por un test y una expresi\
\[OAcute]n. La sintaxis es ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["Which[test1,expr1,test2,expr2,...] ",
  FontFamily->"Courier"]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox[
  "y devuelve el valor de la primera expresi\[OAcute]n para la que el \
correspondiente test da True. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Las expresiones ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times New Roman"],
  StyleBox["expr1,expr2,...",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " pueden estar formadas por varias instrucciones separadas por punto y \
coma. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times New Roman"],
  StyleBox[
  "Podr\[IAcute]amos haber definido nuestra funci\[OAcute]n anterior como \
sigue:",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text"],

Cell["\<\
Clear[f]
f[x_]:= Which[x>0,1,x==0,0,x<0,-1]\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Podemos usar un \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Which[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "\" para definir una funci\[OAcute]n que calcule el factorial de un n\
\[UAcute]mero.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Clear[fac]
fac[n_]:= Which[n>1,n*fac[n-1],n==1,1]\
\>", "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["For", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"El comando For se usa para realizar bucles. Un \[OpenCurlyDoubleQuote]bucle\
\[CloseCurlyDoubleQuote] es un proceso repetitivo que se realiza un cierto n\
\[UAcute]mero de veces. La sintaxis de la orden es "], "Text"],

Cell[TextData[StyleBox["For[expresi\[OAcute]ninicial,test,incr,expr]",
  FontFamily->"Courier"]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "\[Bullet] ",
  StyleBox["expresi\[OAcute]ninicial",
    FontFamily->"Courier"],
  " nos sit\[UAcute]a en las condiciones de comienzo del bucle.\n\[Bullet] ",
  StyleBox["test",
    FontFamily->"Courier"],
  " dir\[AAcute] a Mathematica el momento de detener el proceso.\n\[Bullet] ",
  
  StyleBox["incr",
    FontFamily->"Courier"],
  " expresar\[AAcute] la forma de modificar la condici\[OAcute]n inicial.\n\
\[Bullet] ",
  StyleBox["expr",
    FontFamily->"Courier"],
  " dir\[AAcute] a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lo que tiene que realizar en cada paso; la expresi\[OAcute]n puede estar \
compuesta de varias instrucciones separadas mediante punto y coma.\nEl orden \
de evaluaci\[OAcute]n es ",
  StyleBox["test\[Rule]expr\[Rule]incr.",
    FontFamily->"Courier"],
  StyleBox[
  "El proceso termina cuando test da False. Un aspecto importante de ",
    FontFamily->"Times New Roman"],
  StyleBox["For ",
    FontFamily->"Courier"],
  StyleBox["es que su resultado es ",
    FontFamily->"Times New Roman"],
  StyleBox["Null",
    FontFamily->"Courier"],
  StyleBox[
  " es decir, que no proporciona resultado en pantalla salvo que t\[UAcute] \
se lo indiques de alguna forma expl\[IAcute]cita. Vamos a ver algunos \
ejemplos del funcionamiento de este comando. Ejecuta la siguiente celda.",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[BoxData[{
    \(Clear[i]\), 
    \(For[i = 1, i < 500, \(i++\), i = i^2]\)}], "Input"],

Cell[TextData[{
  "Aparentemente no ha pasado nada pero eso no es as\[IAcute]. Comprueba el \
valor actual de ",
  StyleBox["i",
    FontFamily->"Courier"],
  " (trata de averiguarlo antes de pregunt\[AAcute]rselo a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ")."
}], "Text"],

Cell[BoxData[
    \(i\)], "Input"],

Cell[TextData[{
  "\[DownQuestion]No te lo esperabas? Bien, siempre que quieras saber con \
total claridad todas las operaciones que ha realizado ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para ejecutar un comando tienes a tu disposici\[OAcute]n la orden ",
  StyleBox["Trace",
    FontFamily->"Courier"],
  " (un impagable regalo de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). Observa su funcionamiento."
}], "Text"],

Cell[BoxData[
    \(Trace[For[i = 1, i < 500, \(i++\), i = i^2]]\)], "Input"],

Cell[TextData[{
  "Demasiado largo para explicarlo con palabras pero no sigas adelante antes \
de entender claramente el significado de todos y cada uno de los pasos dados \
por ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " F\[IAcute]jate especialmente en la forma en que se va incrementando el \
valor de ",
  StyleBox["i",
    FontFamily->"Courier New"],
  StyleBox[" despu\[EAcute]s",
    FontSlant->"Italic"],
  " de realizar la operaci\[OAcute]n indicada y por qu\[EAcute] el valor \
actual de ",
  StyleBox["i",
    FontFamily->"Courier"],
  " es 677. Una forma de lograr que For proporcione una salida en pantalla  \
es usando el comando ",
  StyleBox["Print[expr]",
    FontFamily->"Courier"],
  StyleBox["que, precisamente, sirve para imprimir en pantalla.",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[BoxData[{
    \(For[i = 1, i < 500, \(i++\), i = i^2; Print[i]] (*
      observa\ c\[OAcute]mo\ las\ dos\ instrucciones\ al\ final\ van\ 
        separadas\ por\ "\<;\>"\ no\ por\ "\<,\>"*) \), 
    \(i (*\ el\ valor\ actual\ de\ i*) \)}], "Input"],

Cell[TextData[{
  "El \[UAcute]ltimo valor de ",
  StyleBox["i",
    FontFamily->"Courier"],
  " que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha impreso en pantalla es ",
  Cell[BoxData[
      \(TraditionalForm\`676 = \((25 + 1)\)\^2\)]],
  " porque ese fue el \[UAcute]ltimo valor calculado de ",
  StyleBox["i^2. ",
    FontFamily->"Courier"],
  StyleBox["Sin embargo el valor ",
    FontFamily->"Times New Roman"],
  "actual de ",
  StyleBox["i",
    FontFamily->"Courier"],
  " es 677 porque ",
  StyleBox["despu\[EAcute]s",
    FontSlant->"Italic"],
  " de hacer ",
  StyleBox["i",
    FontFamily->"Courier"],
  "=",
  StyleBox["i^2",
    FontFamily->"Courier"],
  "=676 ha incrementado el valor en una unidad al ejecutar la orden ",
  StyleBox["i++",
    FontFamily->"Courier"],
  ". La orden Print debes usarla con prudencia."
}], "Text"],

Cell[TextData[{
  "El comando For tambi\[EAcute]n puede usarse en la forma ",
  StyleBox["For[expresi\[OAcute]ninicial,test,incr]. ",
    FontFamily->"Courier"],
  "Aqu\[IAcute] tienes un ejemplo de ese uso de For con el que podemos \
comprobar que la sucesi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\((1 + 1/n)\)\^n\)]],
  " converge a E aunque muy lentamente. Lo que hacemos es calcular el primer \
n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`\( | \((1 + 1/n)\)\^n - E | \( < 10\^\(-4\)\)\)\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(For[n = 1, Abs[\((1.  + 1/n)\)^n - E] \[GreaterEqual] 10^\(-4\), 
      n = n + 1] (*
      observa\ el\ punto\ decimal\ en\ 1. \ para\ que\ Mathematica\ no\ 
        trabaje\ simb\[OAcute]licamente*) \), 
    \(n\), 
    \(Abs[\((1.  + 1/n)\)^n - E]\)}], "Input"],

Cell[TextData[{
  "La sucesi\[OAcute]n ",
  Cell[BoxData[
      \(\[Sum]\+\(k = 0\)\%n 1\/\(k!\)\)]],
  " converge a E mucho m\[AAcute]s r\[AAcute]pidamente."
}], "Text"],

Cell[BoxData[{
    \(For[n = 1, 
      Abs[\[Sum]\+\(k = 0\)\%n 1. \/\(k!\) - E] \[GreaterEqual] 10^\(-4\), 
      n = n + 1]\), 
    \(n\), 
    \(Abs[\[Sum]\+\(k = 0\)\%n 1. \/\(k!\) - E]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["While", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["While[", "MR",
    FontFamily->"Courier"],
  StyleBox["test", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox[",", "MR",
    FontFamily->"Courier"],
  StyleBox["expr", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox["] ", "MR",
    FontFamily->"Courier"],
  StyleBox["permite realizar repetidamente las instrucciones indicadas en ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["expr",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" mientras ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["test",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" da True y se detiene cuando ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Test",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" da False. Aqu\[IAcute] tienes un ejemplo del uso de ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["While", "MR",
    FontFamily->"Courier"],
  StyleBox[
  " para aproximar, usando el m\[EAcute]todo de Newton-Raphson, una soluci\
\[OAcute]n de la ecuaci\[OAcute]n ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^3 + 1 = 0\)]],
  " partiendo de un valor inicial b. "
}], "Text"],

Cell[BoxData[
    \(f[b_] := 
      Module[{x, k = 0}, 
        x = b;  (*
          Usando\ Module\ las\ variables\ quedan\ localizadas . \ Las\ 
              variables\ locales\ son\ x\ y\ k . \ La\ variable\ k\ se\ ha\ 
              inicializado\ con\ k = 0*) \[IndentingNewLine]\t\t
        While[Abs[x\^3 + 1] > 0.001\  && \ k \[LessEqual] 50\  && \ 
            x \[NotEqual] 0, x = \(\(-1\) + 2  x\^3\)\/\(3\ x\^2\); 
          k = k + 1]; \n
        \t\t{k, x}\  (*
          pedimos\ que\ nos\ devuelva\ el\ \[UAcute]timo\ valor\ de\ k\ que\ 
              es\ el\ n\[UAcute]mero\ de\ iteraciones\ realizadas\  - 
            observa\ que\ k\ empieza\ en\ 0 - 
            y\ de\ x\ que\ es\ el\ valor\ aproximado\ de\ la\ ra\[IAcute]z\ 
              obtenido*) ]\)], "Input"],

Cell[TextData[{
  "Prueba distintos valores para b no demasiado lejanos de la ra\[IAcute]z ",
  Cell[BoxData[
      \(TraditionalForm\`x = \(-1\)\)]],
  ". "
}], "Text"],

Cell[BoxData[
    \({f[\(- .1\)], f[ .15], f[ .55]}\)], "Input"],

Cell["El m\[EAcute]todo tambi\[EAcute]n calcula ra\[IAcute]ces complejas.", 
  "Text"],

Cell[BoxData[
    \({f[1.  + I], f[1.  - I]}\)], "Input"],

Cell["Tambi\[EAcute]n podemos hacer lo mismo con un For.", "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[b_] := 
      Module[{x, k}, \[IndentingNewLine]\t\t
        For[x = b; k = 0, 
          Abs[x\^3 + 1] > 0.001\  && \ k \[LessEqual] 50\  && \ 
            x \[NotEqual] 0, \(k++\), x = \(\(-1\) + 2  x\^3\)\/\(3\ x\^2\)]; 
        \n\t\t{k, x}]\)}], "Input"],

Cell[BoxData[
    \({f[\(- .1\)], f[ .15], f[ .55], f[1.  + I], f[1.  - I]}\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Break", "Subsubsection"],

Cell[TextData[{
  StyleBox["Este comando, cuya sintaxis es simplemente ",
    FontFamily->"Times New Roman"],
  StyleBox["Break[]",
    FontFamily->"Courier"],
  StyleBox[
  ", tiene como \[UAcute]nica finalidad interrumpir la ejecuci\[OAcute]n de \
un bucle. Esto puede ser interesante si, por ejemplo, creemos que el \
resultado que buscamos puede alcanzarse antes de que el ",
    FontFamily->"Times New Roman"],
  StyleBox["test",
    FontFamily->"Courier"],
  StyleBox[
  " del bucle sea False. En el siguiente ejemplo se puede comprender el uso \
de esta orden. Recuerda que en la pr\[AAcute]ctica primera comprobamos que es \
posible sumar una cantidad muy peque\[NTilde]a al n\[UAcute]mero 1. de forma \
que el resultado de la suma, debido a los errores de redondeo de la aritm\
\[EAcute]tica de punto flotante, segu\[IAcute]a siendo igual a 1. Podemos \
calcular el orden de magnitud de esa cantidad tan peque\[NTilde]a con el \
siguiente programa.",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[BoxData[
    \(For[i = 1, i \[LessEqual] 100, \(i++\), 
      \[IndentingNewLine]If[1.  + 10\^\(-i\) \[Equal] 1. , 
        \[IndentingNewLine]\ \ 
        Print[\*"\"\<El exponente i con el que se logra la igualdad 1.+ \
\!\(10\^\(-i\)\)\[Equal] 1. es i=\>\"", i]; 
        \[IndentingNewLine]Break[],  (*\ 
          para\ interrumpir\ la\ ejecuci\[OAcute]n\ del\ bucle\ cuando\ se\ 
            d\[EAcute]\ la\ igualdad\ *) \[IndentingNewLine]Print[
          "\<Para \>", 10. \^\(-i\), "\< no se da la igualdad porque \>", 
          N[1.  + 10\^\(-i\), 14], "\< es distinto de \>", \ \ 1. ]
          \[IndentingNewLine]]\[IndentingNewLine]]\)], "Input"],

Cell[TextData[{
  "Aqu\[IAcute] tienes un uso de ",
  StyleBox["While",
    FontFamily->"Courier"],
  " para definir una funci\[OAcute]n que detecta el primer elemento negativo \
de una lista."
}], "Text"],

Cell["\<\
primerNeg[x_] := Module[{i}, 
(*Usamos Module para localizar la variable i*)
   i = 1;
   While[ x[[i]]>=0, i=i+1 ];
   x[[i]]
]\
\>", "Input",
  AspectRatioFixed->True],

Cell["primerNeg[{3,5,2,-7,4,3,11,-2,0,-1,8}]", "Input",
  AspectRatioFixed->True],

Cell["\<\
La funci\[OAcute]n anterior no est\[AAcute] del todo bien definida. Compru\
\[EAcute]balo.\
\>", "Text"],

Cell["primerNeg[{3,5,2,7,4,3,11,2,0,1,8}]", "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Lo que ha ocurrido es que, al no haber ning\[UAcute]n elemento negativo en \
la lista, el iterador ha alcanzado el valor 12 y la funci\[OAcute]n ha \
tratado de comprobar si el elemento que ocupa dicho lugar en la lista es \
\[GreaterEqual]0 pero la lista solamente tiene 11 elementos. "], "Text"],

Cell[BoxData[
    \(Length[{3, 5, 2, 7, 4, 3, 11, 2, 0, 1, 8}]\)], "Input"],

Cell["\<\
Uno de los ejercicios que te propongo es que modifiques esta funci\[OAcute]n \
para evitar ese error.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Principios generales para trabajar con bucles iterativos", 
  "Subsubsection"],

Cell["\<\
1. Debemos ininializar una o m\[AAcute]s variables (iteradores) antes de \
empezar el bucle.  Es muy conveniente usar Module para localizar dichas \
variables.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox[
"2. Modificamos los iteradores cada vez que se realiza el bucle. Lo \
m\[AAcute]s frecuente es incrementar o decrementar las iteradores.",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "3. Despu\[EAcute]s de que el bucle haya terminado debemos ejecutar alg\
\[UAcute]n comando para pedir una respuesta. Este comando puede consistir \
simplemente en pedir los \[UAcute]ltimos valores de los iteradores o de las \
operaciones realizadas. Por ellos mismos, los bucles no devuelven ning\
\[UAcute]n valor (salida ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Null",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["). En el ejemplo anterior hemos puesto \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["x[[i]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "\" para que el bucle nos devuelva el primer elemento negativo de la \
lista.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox[
"4. Debes asegurarte de que el bucle terminar\[AAcute] en un n\[UAcute]mero \
razonable de pasos y evitar entrar en un bucle infinito.",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Un ejemplo m\[AAcute]s", "Subsubsection"],

Cell[TextData[{
  StyleBox["La funci\[OAcute]n \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PrimeQ[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "\" es un test boleano que comprueba si un n\[UAcute]mero es primo.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?PrimeQ", "Input",
  AspectRatioFixed->True],

Cell["\<\
Vamos a usar dicha funci\[OAcute]n para definir otra que nos devuelva el \
primer n\[UAcute]mero primo mayor que un n\[UAcute]mero dado.\
\>", "Text"],

Cell["\<\
primerPrimoDespues[n_] := 
   Module[{i},
      i = n+1;
      While[ Not[PrimeQ[i] ], i++];
      i
   ]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(primerPrimoDespues[2004]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dos errores que debes evitar.", "Subsubsection"],

Cell["Un bucle no devuelve ning\[UAcute]n valor si no lo pides", "Theorem"],

Cell["\<\
Clear[primerPrimoDespues]
primerPrimoDespues[n_] := 
   Module[{i},
      i = n+1;
      While[ Not[PrimeQ[i] ], i++]
   ] (* esta funci\[OAcute]n hace correctamente su trabajo pero no devuelve \
nada *)\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "La forma de arreglar esto es pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que te proporcione el resultado deseado."
}], "Text"],

Cell["\<\
Clear[primerPrimoDespues]
primerPrimoDespues[n_] := 
   Module[{i},
      i = n+1;
      While[ Not[PrimeQ[i] ], i++]; i (* esta es la peque\[NTilde]a \
diferencia *)
   ] \
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no permite que en un bucle se usen par\[AAcute]metros formales"
}], "Theorem"],

Cell["\<\
Clear[primerPrimoDespues]
primerPrimoDespues[n_] := 
   Module[{},
      n = n+1;
      While[ Not[PrimeQ[n] ], n++];
      n
   ] (*esta funci\[OAcute]n da un error si tratas de usarla*)\
\>", "Input",
  AspectRatioFixed->True],

Cell["\<\
La forma de arreglar esto es f\[AAcute]cil: basta localizar las variables \
dentro de \"Module[ ]\".\
\>", "Text"],

Cell["\<\
Clear[primerPrimoDespues]
primerPrimoDespues[m_] := 
   Module[{n=m},(*esta es la peque\[NTilde]a diferencia*)
      n = n+1;
      While[ Not[PrimeQ[n] ], n++];
      n
   ] \
\>", "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Do", "Subsubsection"],

Cell[TextData[{
  "Se trata de un comando que permite hacer repetidamente una \
operaci\[OAcute]n. Su sintaxis es muy sencilla ",
  StyleBox["Do[expr,{iter}]",
    FontFamily->"Courier"],
  StyleBox["donde ",
    FontFamily->"Times New Roman"],
  StyleBox["expr ",
    FontFamily->"Courier"],
  StyleBox[
  "es una o varias instrucciones separadas por punto y coma y {iter} puede \
ser de varias formas:\n",
    FontFamily->"Times New Roman"],
  StyleBox["{iter}={n\[UAcute]mero}",
    FontFamily->"Courier"],
  StyleBox[" Repite las operaciones indicadas tantas veces como induca \"",
    FontFamily->"Times New Roman"],
  StyleBox["n\[UAcute]mero",
    FontFamily->"Courier"],
  StyleBox["\".\n",
    FontFamily->"Times New Roman"],
  StyleBox["{iter}={i,n\[UAcute]mero}",
    FontFamily->"Courier"],
  StyleBox[" Repite las operaciones indicadas desde ",
    FontFamily->"Times New Roman"],
  StyleBox["i=1",
    FontFamily->"Courier"],
  StyleBox[" hasta ",
    FontFamily->"Times New Roman"],
  StyleBox["i=n\[UAcute]mero",
    FontFamily->"Courier"],
  StyleBox[" incrementando ",
    FontFamily->"Times New Roman"],
  StyleBox["i",
    FontFamily->"Courier"],
  StyleBox[" de uno en uno.\n",
    FontFamily->"Times New Roman"],
  StyleBox["{iter}={i,n\[UAcute]mero1,numero2}",
    FontFamily->"Courier"],
  StyleBox[" Repite las operaciones indicadas desde ",
    FontFamily->"Times New Roman"],
  StyleBox["i=numero1",
    FontFamily->"Courier"],
  StyleBox[" hasta ",
    FontFamily->"Times New Roman"],
  StyleBox["i=n\[UAcute]mero2",
    FontFamily->"Courier"],
  StyleBox[" incrementando ",
    FontFamily->"Times New Roman"],
  StyleBox["i",
    FontFamily->"Courier"],
  StyleBox[" de uno en uno.\n",
    FontFamily->"Times New Roman"],
  StyleBox["{iter}={i,n\[UAcute]mero1,numero2,incr}",
    FontFamily->"Courier"],
  StyleBox[" Repite las operaciones indicadas desde ",
    FontFamily->"Times New Roman"],
  StyleBox["i=numero1",
    FontFamily->"Courier"],
  StyleBox[" hasta ",
    FontFamily->"Times New Roman"],
  StyleBox["i=n\[UAcute]mero2",
    FontFamily->"Courier"],
  StyleBox[" incrementando ",
    FontFamily->"Times New Roman"],
  StyleBox["i",
    FontFamily->"Courier"],
  StyleBox[" de ",
    FontFamily->"Times New Roman"],
  StyleBox["incr",
    FontFamily->"Courier"],
  StyleBox[" en ",
    FontFamily->"Times New Roman"],
  StyleBox["incr",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell["\<\
Aqu\[IAcute] tienes un ejemplo del uso de Do para sumar los cuadrados de los \
n\[UAcute]meros pares desde 2000 a 3000. Observa que debemos inicializar una \
variable \"sum=0\" en la que iremos almacenando los c\[AAcute]lculos y al \
final le pedimos que nos devuelva el valor de dicha variable.\
\>", "Text"],

Cell["\<\
Module[ {sum,i},
   sum = 0;
   Do[sum = sum + i^2, {i,2000,3000,2}];
   sum
]\
\>", "Input",
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Programaci\[OAcute]n basada en listas", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " proporciona la posibilidad de programar usando listas. ",
  StyleBox[
  "Con frecuencia es posible sustituir procesos iterativos y bucles por el \
uso apropiado de listas.",
    FontWeight->"Bold"],
  " Supongamos, por ejemplo, que queremos programar el c\[AAcute]lculo de los \
puntos medios de una lista de n\[UAcute]meros; es decir, se trata de calcular \
los puntos medios de cada dos n\[UAcute]meros consecutivos de la lista dada. \
Hagamos esto de dos formas disferentes. En la primera usamos programaci\
\[OAcute]n procedimental y en la segunda programaci\[OAcute]n basada en \
listas. "
}], "Text"],

Cell[BoxData[
    \(puntosmedios[lista_] := 
      Module[{x},  (*localizamos\ la\ variable\ "\<x\>"*) \ \n\t\t\t
        x = Table[0, {Length[lista] - 1}]\  (*valor\ inicial\ de\ x*) ; \n\t\t
        For[k = 1, k \[LessEqual] \ Length[lista] - 1, 
          x[\([k]\)] = \((lista[\([k]\)] + lista[\([k + 1]\)])\)*0.5; 
          \(k++\)] (*calculamos\ los\ puntos\ medios*) \ ; \n\t\tx
        \  (*pedimos\ a\ Mathematica\ que\ devuelva\ el\ valor\ actual\ de\ 
            x*) ]\)], "Input"],

Cell[BoxData[
    \(puntosmedios[Range[0, 100]]\)], "Input"],

Cell[BoxData[
    \(nuevospuntosmedios[lista_] := 
      \((Drop[lista, 1] + Drop[lista, \(-1\)])\)*0.5\)], "Input"],

Cell[BoxData[
    \(nuevospuntosmedios[Range[0, 100]]\)], "Input"],

Cell[TextData[{
  "Pidamos a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que nos diga el tiempo que tarda en calcular con los comandos que \
acabamos de definir los puntos medios de una lista con los primeros cien mil \
n\[UAcute]meros."
}], "Text"],

Cell[BoxData[
    \(\(Timing[puntosmedios[Range[0, 100000]]]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(\(Timing[nuevospuntosmedios[Range[0, 100000]]]\)[\([1]\)]\)], "Input"],

Cell["\<\
Como puedes comprobar la segunda forma es mucho m\[AAcute]s eficaz que la \
primera.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compresi\[OAcute]n de una lista de datos", "Section"],

Cell[TextData[{
  "Vamos a ver con un ejemplo que, en ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " el uso de comandos espec\[IAcute]ficos para trabajar con listas suele dar \
mejores resultados que la \"programaci\[OAcute]n al estilo C\". \nSe trata de \
comprimir una lista de datos por el procedimiento de sustituir cada cadena de \
m repeticiones de un mismo dato \"x\" por {x,m}. Consideremos, por ejemplo, \
la lista siguiente."
}], "Text"],

Cell[BoxData[
    \(lista = {2, 1, 1, 1, 3, 3, 5, 5, 5, 5, 1, 1, 3, 3, 3, 3, 7}\)], "Input"],

Cell["\<\
La salida del comando que queremos definir debe ser \
{{2,1},{1,3},{3,2},{5,4},{1,2},{3,4},{7,1}}. Podemos usar el comando \
Split[lista] que divide una lista en sublistas formadas por las cadenas de un \
mismo elemento repetido en la lista inicial.\
\>", "Text"],

Cell[BoxData[
    \(temp = Split[lista]\)], "Input"],

Cell["\<\
Todo lo que tenemos que hacer ahora es contar el n\[UAcute]mero de elementos \
de cada una de las sublistas y presentar el resultado de la forma deseada. \
Para ello definimos una funci\[OAcute]n apropiada y la aplicamos a la lista \
anterior.\
\>", "Text"],

Cell[BoxData[
    \(codi[x_] := {x[\([1]\)], Length[x]}; \nMap[codi, temp]\)], "Input"],

Cell["Podemos resumir todo el proceso como sigue.", "Text"],

Cell[BoxData[{
    \(Clear["\<@\>"]\), 
    \(comprime[x_] := 
      Module[{temp, codi}, temp = Split[x]; 
        codi[z_List] := {z[\([1]\)], Length[z]}; 
        \[IndentingNewLine]Map[codi, temp]]\)}], "Input"],

Cell["\<\
Para comprobar la eficacia del comando definido vamos a hacer que codifique \
una lista muy larga. El siguiente comando \"listaaleatoria[n_,prob_]\" genera \
una lista de n elementos cada uno de ellos elegido al azar del 1 al 100 y la \
probabilidad de que un elemento elegido se repita en la siguiente elecci\
\[OAcute]n es igual a \"prob\".\
\>", "Text"],

Cell[BoxData[
    \(listaaleatoria[n_, prob_] := 
      Module[{c}, c = Random[Integer, {1, 100}]; 
        Table[If[Random[] > prob, c = Random[Integer, {1, 100}], c], {n}]]
        \)], "Input",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(listaaleatoria[300,  .7]\)], "Input"],

Cell[BoxData[
    \(d = listaaleatoria[100000,  .7]; \nTiming[comprime[d]; ]\)], "Input",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "Hemos usado comandos espec\[IAcute]ficos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para trabajar con listas (Split[ ]). Podemos hacer esto mismo con \
programaci\[OAcute]n procedimental."
}], "Text"],

Cell[BoxData[
    \(nuevocomprime[x_] := 
      Module[{lista, resultado, cuenta, actual}, lista = x; resultado = {}; 
        While[lista \[NotEqual] {}, actual = First[lista]; cuenta = 0; 
          While[lista \[NotEqual] {} && actual \[Equal] First[lista], 
            \(++cuenta\); lista = Rest[lista]; ]; 
          AppendTo[resultado, {actual, cuenta}]; ]; resultado]\)], "Input",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["Probemos este comando.", "Text"],

Cell[BoxData[{
    \(tp = listaaleatoria[50,  .7]\), 
    \(nuevocomprime[tp]\)}], "Input"],

Cell["Comparamos los dos comandos definidos.", "Text"],

Cell[BoxData[{
    \(d = listaaleatoria[10000,  .7]; \nTiming[comprime[d]; ]\), 
    \(Timing[nuevocomprime[d]; ]\)}], "Input"],

Cell["\<\
La cosa est\[AAcute] clara. Naturalmente, hay ocasiones en las que una \
combinaci\[OAcute]n de estos procedimientos es lo adecuado. \
\>", "Text"],

Cell[BoxData[
    \(\(\(criba[
        n_Integer]\)\(:=\)\(Module[{lista = Range[n], 
          p}, \[IndentingNewLine]For[p = 2, 
          p \[NotEqual] 1 && 
            p \[LessEqual] 
              Floor[Sqrt[
                  n]], \[IndentingNewLine]\(p++\), \[IndentingNewLine]Do[
            lista[\([i]\)] = 1, {i, 2  p, n, 
              p}]]; \[IndentingNewLine]DeleteCases[lista, 1]]\)\( (*\ 
        calcula\ todos\ los\ n\[UAcute]meros\ primos\ menores\ o\ iguales\ \
que\ n\ *) \)\)\)], "Input"],

Cell["Este comando es bastante r\[AAcute]pido.", "Text"],

Cell[BoxData[
    \(Timing[\(criba[100000];\)]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Programaci\[OAcute]n funcional", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " proporciona un entorno de ",
  StyleBox["programaci\[OAcute]n funcional",
    FontSlant->"Italic"],
  " cuyos comandos principales son los siguientes:\n",
  Cell[BoxData[
      FormBox[
        RowBox[{"Nest", "[", 
          RowBox[{"f", ",", 
            StyleBox["expr",
              FontSlant->"Italic"], ",", "n"}], "]"}], TraditionalForm]]],
  " aplica ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " veces la funci\[OAcute]n ",
  StyleBox["f", "TI"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "a ",
  StyleBox["expr", "TI"],
  ". \n",
  Cell[BoxData[
      FormBox[
        RowBox[{"NestList", "[", 
          RowBox[{"f", ",", 
            StyleBox["expr",
              FontSlant->"Italic"], ",", "n"}], "]"}], TraditionalForm]]],
  " proporciona una lista de ",
  Cell[BoxData[
      \(TraditionalForm\`n + 1\)]],
  " elementos cuyos elementos son las iteradas sucesivas de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " sobre ",
  Cell[BoxData[
      FormBox[
        StyleBox["expr",
          FontSlant->"Italic"], TraditionalForm]]],
  ", empezando en el valor inicial ",
  Cell[BoxData[
      FormBox[
        StyleBox["expr",
          FontSlant->"Italic"], TraditionalForm]]],
  " y terminando en ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f\^\([n]\)\), "(", 
          StyleBox["expr",
            FontSlant->"Italic"], ")"}], TraditionalForm]]],
  " (el resultado de aplicar ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " veces a ",
  Cell[BoxData[
      FormBox[
        StyleBox["expr",
          FontSlant->"Italic"], TraditionalForm]]],
  "). \nWhileNestList[",
  StyleBox["f, expr, test",
    FontSlant->"Italic"],
  "] proporciona la lista de las iteradas sucesivas de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " hasta que \"",
  StyleBox["test",
    FontSlant->"Italic"],
  "\" da False. Se entiende que \"test\" es una funci\[OAcute]n booleana que \
act\[UAcute]a sobre las salidas de las iteradas de ",
  StyleBox["f .\n",
    FontSlant->"Italic"],
  "En los comandos anteriores \"",
  StyleBox["expr",
    FontSlant->"Italic"],
  "\" puede ser una lista. En cuyo caso el comando calcula las sucesivas \
listas aplicando a cada elemento de \"",
  StyleBox["expr",
    FontSlant->"Italic"],
  "\" la funci\[OAcute]n ",
  StyleBox["f. ",
    FontSlant->"Italic"],
  "La salida es ahora una lista de listas.",
  "\nFoldList",
  StyleBox["[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{a,b,c,d,...}", "TI"],
  StyleBox["]", "MR"],
  "proporciona la lista ",
  Cell[BoxData[
      \(TraditionalForm\`\(\({x, f[x, a], 
        f[f[x, a], b],  ... }\)\(\ \)\)\)]],
  ".\nFold",
  StyleBox["[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{a,b,c,d,...}", "TI"],
  StyleBox["]", "MR"],
  "proporciona el \[UAcute]ltimo elemento de FoldList",
  StyleBox["[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{a,b,c,d,...}", "TI"],
  StyleBox["]", "MR"],
  ".\nLos siguientes ejemplos muestran la potencia de estos comandos."
}], "Text"],

Cell["\<\
maxima[x_]:= Union[FoldList[Max, First[x], x]] (* esta funci\[OAcute]n \
selecciona en una lista num\[EAcute]rica los elementos que son mayores que \
todos los que les preceden *)
lista = {47,43,43,43,43,43,43,43,43,171,171,171,171,171,171,171,171,88,88,88,\
23,23,23,23,23,23,23,23,90,90,237,237,237,237,53,53,116,140,140,140,140,85,85,\
85,85,85,85,85,85,85,85,85,85,85,241,241,61,61,171,171,171,171,171,196,196,\
196,196,196,196,196,196,196,5,5,5,250,250,250,245,245,245,66,56,56,56,56,56,\
56,56,190,190,190,190,190,34,34,34,34,34,34};
cumbres = maxima[lista]\
\>", "Input",
  CellTags->{"b:16", "IPM3.4.6.1"}],

Cell[TextData[{
  "Si quieres saber los lugares que ocupan los n\[UAcute]meros anteriores",
  StyleBox[" la primera vez",
    FontSlant->"Italic"],
  " que aparecen en la lista, puedes hacerlo como sigue."
}], "Text"],

Cell[BoxData[
    \(Table[{cumbres[\([k]\)], \(Position[lista, cumbres[\([k]\)]]\)[\([1, 
            1]\)]}, {k, 1, 5}]\)], "Input"],

Cell[BoxData[
    \(Clear["\<@\>"]\)], "Input"],

Cell[BoxData[{
    RowBox[{\(g[z_] := I^z\), "   ", 
      \( (*definimos\ una\ funci\[OAcute]n\ que\ vamos\ a\ iterar*) \), 
      " "}], 
    RowBox[{\(lista = NestList[g, 0.  + I, 39]\), " ", 
      RowBox[{"(*", 
        RowBox[{
        "los", " ", "primeros", " ", "40", " ", "t\[EAcute]rminos", " ", 
          "de", " ", "la", " ", "sucesi\[OAcute]n", " ", 
          FormBox[
            RowBox[{\(x[n + 1]\), "=", 
              RowBox[{\(\[ImaginaryI]\^x[n]\), "con", " ", 
                FormBox[\(x[1] = \[ImaginaryI]\),
                  "TraditionalForm"]}]}],
            "TraditionalForm"]}], "*)"}]}], 
    RowBox[{
      \(Show[Graphics[{PointSize[ .015], 
            Map[Point, Transpose[{Re[lista], Im[lista]}]]}], 
        Axes \[Rule] True, PlotRange \[Rule] All, AspectRatio \[Rule] 1]; \), 
      " ", \( (*representamos\ gr\[AAcute]ficamente\ los\ puntos*) \)}]}], 
  "Input"],

Cell["\<\
Veamos una funci\[OAcute]n que extrae 5 cartas al azar de una baraja de 40 \
cartas.\
\>", "Text"],

Cell[BoxData[{
    \(cartas = 
      Flatten[Outer[List, 
          Range[10], {\[ClubSuit], \[SpadeSuit], \[FilledDiamond], 
            \[HeartSuit]}], 1] (*nuestra\ baraja*) \), 
    \(extrae := 
      Module[{elige}, 
        elige[lista_] := Drop[lista, {Random[Integer, {1, Length[lista]}]}]; 
        \[IndentingNewLine]Complement[cartas, Nest[elige, cartas, 5]]]\)}], 
  "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios", "ExerciseMain"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell["\<\
Define una funci\[OAcute]n que devuelva el primer elemento negativo de una \
lista y en caso de que la lista no tenga elementos negativos devuelva la \
expresi\[OAcute]n \"la lista no tiene elementos negativos\".\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Dado un n\[UAcute]mero x>0, se puede consguir que la suma  ",
  StyleBox["1/1 + 1/2 + 1/3 + 1/4 + ...+1/n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["  sea mayor que x ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times New Roman"],
  "tomando un n\[UAcute]mero ",
  StyleBox["n",
    FontFamily->"Courier"],
  " suficientemente grande. Define una funci\[OAcute]n que calcule el primer \
n\[UAcute]mero ",
  StyleBox["n",
    FontFamily->"Courier"],
  " que satisface dicha condici\[OAcute]n. Calcula ",
  StyleBox["n",
    FontFamily->"Courier"],
  " para x=10,11,13. \nSugerencia. Debes evitar que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcule simb\[OAcute]licamente."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Define una funci\[OAcute]n que calcule el menor n\[UAcute]mero natural ",
  StyleBox["n",
    FontFamily->"Courier"],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`2\^n\)]],
  " es mayor que un n\[UAcute]mero dado ",
  StyleBox["x",
    FontFamily->"Courier"],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Los n\[UAcute]meros de Fibonacci son los elementos de la sucesi\[OAcute]n \
1,1,2,3,5,8,13,21,34,... cuyos primeros dos elementos son iguales a 1 y cada \
elemento posterior es la suma de los dos que le preceden. Define una funci\
\[OAcute]n que calcule el n-\[EAcute]simo n\[UAcute]mero de Fibonacci F[n]. \
Utiliza ListPlot[ ] (consulta la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ") para representar los n\[UAcute]meros de Fibonacci desde F[200] hasta \
F[250]. Repres\[EAcute]ntalos en rojo con un tama\[NTilde]o apropiado."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["M\[EAcute]todo de bisecci\[OAcute]n", "Section"],

Cell[TextData[{
  StyleBox[
  "En este m\[EAcute]todo s\[OAcute]lo es necesario que la funci\[OAcute]n ",
    FontFamily->"Times New Roman"],
  StyleBox["f ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["sea continua en el intervalo",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \([a, \ b]\)\)\)]],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["y verifique ",
    FontFamily->"Times New Roman"],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"f", 
              StyleBox["(",
                FontSlant->"Italic"], 
              StyleBox["a",
                FontSlant->"Italic"], 
              StyleBox[")",
                FontSlant->"Italic"]}], 
            StyleBox["f",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              StyleBox["b",
                FontSlant->"Italic"], 
              StyleBox[")",
                FontSlant->"Italic"]}]}], 
          StyleBox[" ",
            FontSlant->"Italic"], "<", " ", "0"}], TraditionalForm]]],
  StyleBox[
  ". En estas condiciones, el Teorema de Bolzano nos asegura la existencia de \
una soluci\[OAcute]n de la ecuaci\[OAcute]n ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`f(x) = 0\)]],
  StyleBox[" en ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`\([a, \ b]\)\)]],
  StyleBox[
  ". El siguiente paso consiste en tomar como primera aproximaci\[OAcute]n, ",
    
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`c\  = \ \((a + b)\)/2\)]],
  StyleBox[" (el punto medio del segmento ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`\([a, \ b]\)\)]],
  StyleBox["). Si ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`f\ \((c)\)\  = \ 0\)]],
  StyleBox[
  ", hemos encontrado una soluci\[OAcute]n de la ecuaci\[OAcute]n y por tanto \
hemos terminado. Si ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`f\ \((c)\) \[NotEqual] 0\)]],
  StyleBox[", consideramos como nuevo intervalo, o bien ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`\([a, \ c]\)\)]],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["si ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`f\ \((a)\) f\ \((c)\)\  < \ 0\)]],
  StyleBox[", o bien ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`\([c, \ b]\)\)]],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["si ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ f\ \((c)\) f\ \((b)\)\  < \ 0\)\)]],
  StyleBox[
  " y repetimos la estrategia en el nuevo intervalo. En este m\[EAcute]todo \
es f\[AAcute]cil cntrolar el error que cometemos en cada una de las \
aproximaciones. En cada paso dividimos por 2 la longitud del intervalo donde \
se encuentra la ra\[IAcute]z por lo que el error cometido en la aproximaci\
\[OAcute]n n-\[EAcute]sima es menor que ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`\((b - a)\)/2\^n\)]],
  ".",
  StyleBox[
  " A partir de aqu\[IAcute], podemos calcular el n\[UAcute]mero de \
iteraciones necesarias para obtener una aproximaci\[OAcute]n con un error \
prefijado. Si notamos por \"Er\" al error prefijado, el n\[UAcute]mero \
\[OpenCurlyDoubleQuote]",
    FontFamily->"Times New Roman"],
  StyleBox["n",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[
  "\[CloseCurlyDoubleQuote] de iteraciones necesarias deber\[AAcute] \
satisfacer ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`\((b\  - \ a)\)/2\^n < Er\)]],
  StyleBox[". ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios", "Section"],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "Haz un programa b\[AAcute]sico para calcular ra\[IAcute]ces de una funci\
\[OAcute]n en un intervalo usando el m\[EAcute]todo de bisecci\[OAcute]n. El \
programa debe admitir como datos de entrada la funci\[OAcute]n, el intervalo \
y el error admitido y debe proporcionar la soluci\[OAcute]n encontrada y el n\
\[UAcute]mero de pasos que han sido necesarios para calcularla. \nPuedes \
mejorar el programa b\[AAcute]sico controlando la precisi\[OAcute]n de los \
datos iniciales, por ejemplo, con N[a,n], N[b,n] donde a y b son los extremos \
del intervalo. Tambi\[EAcute]n puedes pedir a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que presente la soluci\[OAcute]n hallada con n d\[IAcute]gitos."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["M\[EAcute]todo de Newton-Raphson", "Section"],

Cell[TextData[{
  "El m\[EAcute]todo de Newton-Raphson es una t\[EAcute]cnica frecuentemente \
usada para calcular soluciones de una ecuaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f(x) = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Para ello, se elige un valor inicial ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_1\),
          FontWeight->"Bold"], TraditionalForm]]],
  " y, a partir de \[EAcute]l, se forma la sucesi\[OAcute]n definida por",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{\(x\_\(n + 1\)\), "=", 
          RowBox[{\(x\_n\), "-", 
            StyleBox[\(\(f(x\_n)\)\/\(f\ ' \((x\_n)\)\)\),
              FontSize->16]}]}], TraditionalForm]],
    FontWeight->"Bold"],
  ". Si dicha sucesi\[OAcute]n converge, su l\[IAcute]mite es una soluci\
\[OAcute]n de la ecuaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f(x) = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Naturalmente, cuando hay m\[AAcute]s de una soluci\[OAcute]n, la elecci\
\[OAcute]n del valor inicial determina a cu\[AAcute]l de ellas converge el \
proceso. Es f\[AAcute]cil comprobar que el punto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_\(n + 1\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "se obtiene como el punto de corte de la recta tangente a la curva ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(y = f(x)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " en el punto",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\((x\_n, f(x\_n))\)\)],
    FontWeight->"Bold"],
  " con el eje de abscisas. Con este m\[EAcute]todo no es tan inmediato \
acotar el error cometido en la aproximaci\[OAcute]n. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " usa este procedimiento en el comando \"FindRoot[ ]\". Aqu\[IAcute] puedes \
apreciar c\[OAcute]mo se van obteniendo gr\[AAcute]ficamente las sucesivas \
aproximaciones."
}], "Text"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.353162 0.0176581 [
[0 .34066 -6 -9 ]
[0 .34066 6 0 ]
[.16667 .34066 -6 -9 ]
[.16667 .34066 6 0 ]
[.33333 .34066 -6 -9 ]
[.33333 .34066 6 0 ]
[.66667 .34066 -3 -9 ]
[.66667 .34066 3 0 ]
[.83333 .34066 -3 -9 ]
[.83333 .34066 3 0 ]
[1 .34066 -3 -9 ]
[1 .34066 3 0 ]
[.4875 0 -18 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .08829 -18 -4.5 ]
[.4875 .08829 0 4.5 ]
[.4875 .17658 -18 -4.5 ]
[.4875 .17658 0 4.5 ]
[.4875 .26487 -12 -4.5 ]
[.4875 .26487 0 4.5 ]
[.4875 .44145 -6 -4.5 ]
[.4875 .44145 0 4.5 ]
[.4875 .52974 -12 -4.5 ]
[.4875 .52974 0 4.5 ]
[.4875 .61803 -12 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .35316 m
0 .35941 L
s
[(-3)] 0 .34066 0 1 Mshowa
.16667 .35316 m
.16667 .35941 L
s
[(-2)] .16667 .34066 0 1 Mshowa
.33333 .35316 m
.33333 .35941 L
s
[(-1)] .33333 .34066 0 1 Mshowa
.66667 .35316 m
.66667 .35941 L
s
[(1)] .66667 .34066 0 1 Mshowa
.83333 .35316 m
.83333 .35941 L
s
[(2)] .83333 .34066 0 1 Mshowa
1 .35316 m
1 .35941 L
s
[(3)] 1 .34066 0 1 Mshowa
.125 Mabswid
.03333 .35316 m
.03333 .35691 L
s
.06667 .35316 m
.06667 .35691 L
s
.1 .35316 m
.1 .35691 L
s
.13333 .35316 m
.13333 .35691 L
s
.2 .35316 m
.2 .35691 L
s
.23333 .35316 m
.23333 .35691 L
s
.26667 .35316 m
.26667 .35691 L
s
.3 .35316 m
.3 .35691 L
s
.36667 .35316 m
.36667 .35691 L
s
.4 .35316 m
.4 .35691 L
s
.43333 .35316 m
.43333 .35691 L
s
.46667 .35316 m
.46667 .35691 L
s
.53333 .35316 m
.53333 .35691 L
s
.56667 .35316 m
.56667 .35691 L
s
.6 .35316 m
.6 .35691 L
s
.63333 .35316 m
.63333 .35691 L
s
.7 .35316 m
.7 .35691 L
s
.73333 .35316 m
.73333 .35691 L
s
.76667 .35316 m
.76667 .35691 L
s
.8 .35316 m
.8 .35691 L
s
.86667 .35316 m
.86667 .35691 L
s
.9 .35316 m
.9 .35691 L
s
.93333 .35316 m
.93333 .35691 L
s
.96667 .35316 m
.96667 .35691 L
s
.25 Mabswid
0 .35316 m
1 .35316 L
s
.5 0 m
.50625 0 L
s
[(-20)] .4875 0 1 0 Mshowa
.5 .08829 m
.50625 .08829 L
s
[(-15)] .4875 .08829 1 0 Mshowa
.5 .17658 m
.50625 .17658 L
s
[(-10)] .4875 .17658 1 0 Mshowa
.5 .26487 m
.50625 .26487 L
s
[(-5)] .4875 .26487 1 0 Mshowa
.5 .44145 m
.50625 .44145 L
s
[(5)] .4875 .44145 1 0 Mshowa
.5 .52974 m
.50625 .52974 L
s
[(10)] .4875 .52974 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(15)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01766 m
.50375 .01766 L
s
.5 .03532 m
.50375 .03532 L
s
.5 .05297 m
.50375 .05297 L
s
.5 .07063 m
.50375 .07063 L
s
.5 .10595 m
.50375 .10595 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .14126 m
.50375 .14126 L
s
.5 .15892 m
.50375 .15892 L
s
.5 .19424 m
.50375 .19424 L
s
.5 .2119 m
.50375 .2119 L
s
.5 .22956 m
.50375 .22956 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .28253 m
.50375 .28253 L
s
.5 .30019 m
.50375 .30019 L
s
.5 .31785 m
.50375 .31785 L
s
.5 .3355 m
.50375 .3355 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .38848 m
.50375 .38848 L
s
.5 .40614 m
.50375 .40614 L
s
.5 .42379 m
.50375 .42379 L
s
.5 .45911 m
.50375 .45911 L
s
.5 .47677 m
.50375 .47677 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .51209 m
.50375 .51209 L
s
.5 .5474 m
.50375 .5474 L
s
.5 .56506 m
.50375 .56506 L
s
.5 .58272 m
.50375 .58272 L
s
.5 .60038 m
.50375 .60038 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 .40614 m
.00942 .40885 L
.01975 .4112 L
.02496 .41215 L
.03053 .41299 L
.03575 .41361 L
.04057 .41405 L
.04334 .41425 L
.04628 .41442 L
.0477 .41448 L
.04923 .41454 L
.0501 .41456 L
.0509 .41458 L
.05166 .4146 L
.05248 .41461 L
.05323 .41462 L
.05391 .41463 L
.05523 .41464 L
.05598 .41464 L
.05679 .41463 L
.05755 .41463 L
.05825 .41462 L
.05952 .4146 L
.06091 .41457 L
.06237 .41452 L
.06373 .41447 L
.06646 .41434 L
.06905 .41418 L
.0739 .41381 L
.07913 .41328 L
.08481 .41256 L
.09468 .41098 L
.10557 .40875 L
.12763 .40286 L
.16984 .38712 L
.21047 .3678 L
.25366 .3445 L
.29527 .32106 L
.33528 .29916 L
.37787 .27819 L
.41887 .26191 L
.44128 .25521 L
.45156 .25275 L
.46244 .2506 L
.47245 .24906 L
.47813 .24839 L
.48345 .24789 L
.48596 .2477 L
.48834 .24755 L
.4905 .24744 L
Mistroke
.4928 .24734 L
.4941 .2473 L
.49529 .24727 L
.49648 .24724 L
.4976 .24723 L
.49891 .24722 L
.50011 .24721 L
.50143 .24722 L
.5021 .24722 L
.50283 .24723 L
.50421 .24726 L
.50548 .24729 L
.50687 .24733 L
.50835 .24739 L
.51083 .24752 L
.51357 .24769 L
.51862 .24812 L
.52336 .24865 L
.53394 .25029 L
.54533 .25279 L
.55541 .25567 L
.56641 .25955 L
.58858 .26982 L
.60921 .28251 L
.63123 .29962 L
.67485 .34535 L
.71689 .40574 L
.75733 .48059 L
.80035 .57995 L
Mfstroke
.80035 .57995 m
.81389 .61803 L
s
0 .03871 m
.04057 .05452 L
.08481 .07177 L
.12636 .08797 L
.16632 .10355 L
.20885 .12014 L
.2498 .1361 L
.29331 .15307 L
.33524 .16941 L
.37557 .18514 L
.41848 .20187 L
.4598 .21798 L
.49953 .23347 L
.54183 .24996 L
.58254 .26583 L
.62583 .28271 L
.66752 .29897 L
.70762 .3146 L
.7503 .33124 L
.79139 .34726 L
.83505 .36428 L
.87712 .38069 L
.9176 .39647 L
.96065 .41326 L
1 .4286 L
s
1 0 0 r
.008 w
.56667 .35316 Mdot
.80652 .35316 Mdot
.56667 .25964 Mdot
.5 Mabswid
.56667 .35316 m
.56667 .25964 L
s
.016 w
.56667 .35316 Mdot
.80652 .35316 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{271.75, 167.875},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005C0000dB000`400?l00000o`00003oo`3ooomD
0?ooo`00o`3ooomD0?ooo`00U`3oool00`3oj[X0LP00000000030000000509_Do`3oool0oooo0?oo
o`2jLP000P0000000`00Vm@0oooo0?ooo`2/0?ooo`00V03oool00`3DV`0007:j0?ooo`050?ooo`06
0?oZ^P2K^^X0oooo0?ooo`3DV`00VmCo[@3oool009T0oooo00<0j[Yb0000LP2jj_l0103oool01P3D
V`00VmCo0?ooo`3oool0onZj07:Ke:d0oooo002?0?ooo`030?ooe02K0000000000<0000000<0002K
0=Coo`3oool00P3oool00`3oj[X0LP0009_Do`030?ooo`060=BKLP2jj_l0oooo0?ooo`3oj[X0LW:j
1@3oool300000:D0oooo002K0?ooo`030?ooe02KL[X0oooo0080oooo00H0e9]b0;[Zo`3oool0oooo
0?oZ^P1bL[X50?ooo`030000003oool0oooo0:D0oooo002L0?ooo`060>ZjLP2Ke?l0oooo0?ooo`3D
Vg80^^[o0P3oool00`3oj[X0LY_D0?ooo`040?ooo`030000003oool0oooo0:D0oooo002H0?ooo`06
0=BK001b^^X0oooo0?ooe02K0000VmCo0P3oool01P3oe9/007:j0?ooo`3oool0e9/009_Do`D0oooo
00<000000?ooo`3oool0Y@3oool009T0oooo00@0^W80000000000000L[[Z103oool0103Z^W800000
00000000Vm@60?ooo`030000003oool0oooo0:D0oooo002[0?ooo`030000003oool0oooo0:D0oooo
002[0?ooo`800000YP3oool00:/0oooo00<000000?ooo`3oool0Y@3oool00:/0oooo00<000000?oo
o`3oool0Y@3oool00:/0oooo00<000000?ooo`3oool0Y@3oool00:/0oooo00<000000?ooo`3oool0
Y@3oool00:/0oooo00<000000?ooo`3oool0Y@3oool00:/0oooo0P00002V0?ooo`002`3oool20000
09h0oooo00<000000?ooo`3oool0Y@3oool000d0oooo0P00002L0?ooo`030000003oool0oooo0:D0
oooo000?0?ooo`<00000V@3oool00`000000oooo0?ooo`2U0?ooo`004P3oool3000009H0oooo00<0
00000?ooo`3oool0Y@3oool001D0oooo0P00002D0?ooo`800000YP3oool001L0oooo0`00002A0?oo
o`030000003oool0oooo0:D0oooo000J0?ooo`<00000SP3oool00`000000oooo0?ooo`2U0?ooo`00
7@3oool2000008`0oooo00<000000?ooo`3oool0Y@3oool001l0oooo0`0000290?ooo`030000003o
ool0oooo0:D0oooo000R0?ooo`<00000QP3oool00`000000oooo0?ooo`2U0?ooo`009@3oool30000
08<0oooo0P00002V0?ooo`00:03oool200000840oooo00<000000?ooo`3oool0Y@3oool002X0oooo
0`00001n0?ooo`030000003oool0oooo0:D0oooo000]0?ooo`<00000J03oool00`3DV`0000000000
000200000005001b^P3oool0oooo0?ooo`2jLP000P0000000`00L[X0oooo0?ooo`040?ooo`030000
003oool0oooo0:D0oooo000`0?ooo`800000J03oool00`3oe9/0L[[Z0?ooo`030?ooo`060;Yb001b
^^X0oooo0?ooo`3Z^W8009_D1@3oool00`000000oooo0?ooo`2U0?ooo`00<P3oool3000006D0oooo
00<0omBK07:jjP3oool01`3oool00`3oom@0Vg:j0?ooo`040?ooo`030000003oool0oooo0:D0oooo
000e0?ooo`800000F03oool00`3oom@0V`0000000003000000030000V`3Dool0oooo0080oooo00<0
omBK07:jjP3oool01`3oool00`3oe9/009_D0?ooo`040?ooo`<00000Y@3oool003L0oooo0`00001P
0?ooo`030?oDV`1b^^X0oooo00<0oooo00H0onZj07800000000000000000V`3Dool50?ooo`030000
003oool0oooo0:D0oooo000j0?ooo`<00000G@3oool00`3oe9/0L[[Z0?ooo`030?ooo`030?oZ^P1b
Vm@0oooo00P0oooo00<000000?ooo`3oool0Y@3oool003d0oooo0P00001I0?ooo`040>ZjLP00Vm@0
omBK07:jjP@0oooo00<0onZj07:Ke03oool0203oool00`000000oooo0?ooo`2U0?ooo`00?`3oool3
000005L0oooo00<0e9/00000001b^^X0103oool01P3oj[X0LP00000000000000002K0=Coo`D0oooo
00<000000?ooo`3oool0Y@3oool00480oooo0P00001W0?ooo`800000YP3oool004@0oooo0P00001U
0?ooo`030000003oool0oooo0:D0oooo00160?ooo`<00000HP3oool00`000000oooo0?ooo`2U0?oo
o`00B@3oool200000600oooo00<000000?ooo`3oool0Y@3oool004/0oooo0P00001N0?ooo`030000
003oool0oooo0:D0oooo001=0?ooo`<00000F`3oool00`000000oooo0?ooo`2U0?ooo`00D03oool2
000005T0oooo0P00002V0?ooo`00DP3oool3000005H0oooo00<000000?ooo`3oool0Y@3oool005D0
oooo0`00001C0?ooo`030000003oool0oooo0:D0oooo001H0?ooo`800000D@3oool00`000000oooo
0?ooo`2U0?ooo`00FP3oool3000004h0oooo00<000000?ooo`3oool0Y@3oool005d0oooo0`00001;
0?ooo`800000YP3oool00600oooo0P0000190?ooo`030000003oool0oooo0:D0oooo001R0?ooo`<0
0000AP3oool00`000000oooo0?ooo`2U0?ooo`00I@3oool3000004<0oooo00<000000?ooo`3oool0
Y@3oool006P0oooo0`0000100?ooo`030000003oool0oooo0:D0oooo001[0?ooo`800000?P3oool0
0`000000oooo0?ooo`2U0?ooo`00K@3oool3000003/0oooo0P00002V0?ooo`00L03oool3000003P0
oooo00<000000?ooo`3oool0Y@3oool007<0oooo0P00000f0?ooo`030000003oool0oooo0:D0oooo
001e0?ooo`<00000803oool00`3DV`0000000000000200000005001b^P3oool0oooo0?ooo`2jLP00
0P0000000`00Vm@0oooo0?ooo`040?ooo`030000003oool0oooo0:D0oooo001h0?ooo`800000803o
ool00`3oe9/0L[[Z0?ooo`030?ooo`060?oZ^P2K^^X0oooo0?ooo`3DV`00VmCo1@3oool00`000000
oooo0?ooo`2U0?ooo`00NP3oool3000001d0oooo00<0omBK07:jjP3oool00`3oool01P3DV`00VmCo
0?ooo`3oool0onZj07:Ke0D0oooo00<000000?ooo`3oool0Y@3oool007d0oooo0`00000?0?ooo`03
0?ooe02K0000000000<0000000<0002K0=Coo`3oool00P3oool00`3oe9/0L[[Z0?ooo`030?ooo`06
0=BKLP2jj_l0oooo0?ooo`3oj[X0LW:j1@3oool300000:D0oooo00200?ooo`800000603oool00`3o
e9/0L[[Z0?ooo`030?ooo`060=BKLP2jj_l0oooo0?ooo`3oj[X0LW:j1@3oool00`000000oooo0?oo
o`2U0?ooo`00PP3oool3000001D0oooo00<0omBK07:jjP3oool00`3oool01P3DVg80^^[o0?ooo`3o
ool0onZj07:Ke0D0oooo00<000000?ooo`3oool0Y@3oool008D0oooo0P00000A0?ooo`040>ZjLP00
Vm@0omBK07:jjP@0oooo00H0omBK001b^P3oool0oooo0=BK002Ke?l50?ooo`030000003oool0oooo
0:D0oooo00270?ooo`800000403oool00`3DV`00000007:jjP050?ooo`040>ZjLP0000000000002K
e0H0oooo00<000000?ooo`3oool0Y@3oool008T0oooo0`00000O0?ooo`800000YP3oool008`0oooo
0P00000M0?ooo`030000003oool0oooo0:D0oooo002>0?ooo`8000006`3oool00`000000oooo0?oo
o`2U0?ooo`00T03oool3000001P0oooo00<000000?ooo`3oool0Y@3oool009<0oooo0P00000F0?oo
o`030000003oool0oooo0:D0oooo002E0?ooo`<000004`3oool00`000000oooo0?ooo`2U0?ooo`00
V03oool300000100oooo0P00002V0?ooo`00V`3oool2000000h0oooo00<000000?ooo`3oool0Y@3o
ool009d0oooo0`00000;0?ooo`030000003oool0oooo0:D0oooo002P0?ooo`8000002@3oool00`00
0000oooo0?ooo`2U0?ooo`00XP3oool3000000H0oooo00<000000?ooo`3oool0Y@3oool00:D0oooo
0`0000030?ooo`030000003oool0oooo0:D0oooo002X0?ooo`80000000<0oooo000000000000YP3o
ool00:X0oooo0`00002V0?ooo`00Z`3oool010000000oooo00000000002T0?ooo`00Z`3oool01000
0000oooo0?ooo`3oool300000:40oooo002[0?ooo`030000003oool0oooo00@0oooo0`00002N0?oo
o`00YP3oool:000000D0oooo0P00002L0?ooo`00WP3oool8000000D0oooo00<000000?ooo`3oool0
0P3oool:000009T0oooo002J0?ooo`@000003@3oool00`000000oooo0?ooo`0:0?ooo`@00000U`3o
ool009L0oooo0`0000070?ooo`040;Yb000000000000001b^PH0oooo00<000000?ooo`3oool03@3o
ool4000009@0oooo002C0?ooo`@000002@3oool01P2jLP00L[[Z0?ooo`3oool0j[Yb002Ke0D0oooo
00<000000?ooo`3oool0403oool010000000o`000?l00000002A0?ooo`00T03oool300000140oooo
00<0oooD09]b^P3oool0103oool00`000000oooo0?ooo`0A0?ooo`80o`000`00002?0?ooo`00SP3o
ool2000000L0oooo00<0oooD09/0000000000`0000000`0009/0e?oo0?ooo`040?ooo`030?oDV`00
Vm@0oooo00@0oooo0`00000B0?ooo`030?l0003oool0oooo00@00000S03oool008/0oooo0`00000B
0?ooo`060?oZ^P1b000000000000000009/0e?oo1@3oool00`000000oooo0?ooo`0B0?ooo`030?l0
003oool0oooo0080oooo1000002:0?ooo`00R03oool3000001D0oooo00<0onZj07:Ke03oool0203o
ool00`000000oooo0?ooo`0B0?ooo`030?l0003oool0oooo00@0oooo00@000000?ooo`0000000000
R03oool008H0oooo0P00000H0?ooo`030?oZ^P1bVm@0oooo00P0oooo00<000000?ooo`3oool04P3o
ool00`3o0000oooo0?ooo`050?ooo`80000000@0oooo0000000000000000Q@3oool008@0oooo0P00
000J0?ooo`060?oZ^P1b000000000000000009/0e?oo1@3oool00`000000oooo0?ooo`0B0?ooo`03
0?l0003oool0oooo00L0oooo0P0000020?ooo`800000P`3oool00880oooo0P00000W0?ooo`030000
003oool0oooo0180oooo00<0o`000?ooo`3oool02@3oool200000080oooo0P0000210?ooo`00P03o
ool2000002T0oooo0P00000C0?ooo`030?l0003oool0oooo00/0oooo00@000000?ooo`3oool0oooo
0`00001n0?ooo`00OP3oool2000002/0oooo00<000000?ooo`3oool04P3oool00`3o0000oooo0?oo
o`0<0?ooo`800000103oool2000007`0oooo001l0?ooo`800000;@3oool00`000000oooo0?ooo`0B
0?ooo`030?l0003oool0oooo00h0oooo00<000000?ooo`3oool00`3oool3000007T0oooo001j0?oo
o`800000;`3oool00`000000oooo0?ooo`0B0?ooo`030?l0003oool0oooo00l0oooo00<000000?oo
o`3oool01@3oool3000007H0oooo001h0?ooo`800000<@3oool00`000000oooo0?ooo`0B0?ooo`03
0?l0003oool0oooo0100oooo0P0000080?ooo`800000M03oool007H0oooo0P00000c0?ooo`800000
4`3oool00`3o0000oooo0?ooo`0B0?ooo`030000003oool0oooo00L0oooo0`00001a0?ooo`00M03o
ool2000003D0oooo00<000000?ooo`3oool04P3oool00`3o0000oooo0?ooo`0C0?ooo`030000003o
ool0oooo00T0oooo0P00001_0?ooo`00303oool01@3oom@0V`0000000000000007:j02l0oooo00<0
onZj0780000000000`0000000`2Ke?l0oooo0?ooo`0Y0?ooo`8000000P3oool00`3DV`0000000000
000200000003001b^P3oool0oooo02d0oooo00<000000?ooo`3oool04P3oool00`3o0000oooo0?oo
o`0D0?ooo`030000003oool0oooo00<0oooo00<0e9/00000000000000P0000000`00L[X0oooo0000
0002000002X0oooo00<0onZj0780000000000`0000000`2Ke?l0oooo0?ooo`0^0?ooo`050?ooe02K
0000000000000000L[X01P3oool000`0oooo00H0^W8009_Do`3oool0oooo0=BK0000Vm@_0?ooo`03
0=BK0000L[X0oooo02`0oooo0P0000060?ooo`030?oDV`1b^^X0oooo0300oooo00<000000?ooo`3o
ool04P3oool00`3o0000oooo0?ooo`0E0?ooo`030000003oool0oooo00@0oooo00<0omBK07:jjP3o
ool01@3oool3000002P0oooo00<0e9/0001b^P3oool0<`3oool01P2jLP00VmCo0?ooo`3oool0e9/0
002Ke0D0oooo000@0?ooo`030?ooe02KL[X0oooo02l0oooo00<0j[Yb0000LP2jj_l0:@3oool20000
00P0oooo00<0omBK07:jjP3oool0<03oool00`000000oooo0?ooo`0B0?ooo`030?l0003oool0oooo
01H0oooo00<000000?ooo`3oool00`3oool00`3oe9/0L[[Z0?ooo`080?ooo`8000009`3oool00`3Z
^W80001b0;[Zo`0f0?ooo`030?ooe02KL[X0oooo00@0oooo00030?ooo`030?ooe02K0000000000<0
000000<0002K0=Coo`3oool0103oool00`3DV`00L[[Z0?ooo`0U0?ooo`030?ooe02K0000000000<0
000000<0002K0=Coo`3oool00P3oool00`3oj[X0LP0009_Do`0V0?ooo`80000000<0V`0000000000
00000P0000000`0009/0e?oo0?ooo`020?ooo`030?oDV`1b^^X0oooo0300oooo00<000000?ooo`3o
ool04P3oool00`3o0000oooo0?ooo`0G0?ooo`030000003oool0oooo0080oooo00<0omBK07:jjP3o
ool02P3oool3000002D0oooo00<0onZj0780002Ke?l0=@3oool00`3DV`00L[[Z0?ooo`040?ooo`00
3@3oool0103oom@0V`0000000000L[Xc0?ooo`030?ooe02KL[X0oooo02<0oooo0P00000<0?ooo`03
0?oDV`1b^^X0oooo0300oooo0P00000C0?ooo`030?l0003oool0oooo01P0oooo00H000000?ooo`3o
ool0oooo0?oDV`1b^^X>0?ooo`<000008`3oool00`3oom@0Vg:j0?ooo`0a0?ooo`040?ooe02K0000
0000001b^PH0oooo000@0?ooo`030>ZjLP1b^^X0oooo0380oooo00<0j[Yb09_Do`3oool08@3oool0
0`000000oooo0?ooo`0<0?ooo`030?oDV`1b^^X0oooo0300oooo00<000000?ooo`3oool04P3oool0
0`3o0000oooo0?ooo`0I0?ooo`050000003oool0oooo0?oDV`1b^^X04@3oool200000280oooo00<0
j[Yb09_Do`3oool0<`3oool00`3Z^W80L[[Z0?ooo`040?ooo`00303oool01P3DV`0007:j0?ooo`3o
ool0j[Yb07:jjRl0oooo00H0e9/007:jjP3oool0oooD09/0002Ke?lP0?ooo`8000003@3oool0103Z
^W8009_D0?oDV`1b^^Xa0?ooo`030000003oool0oooo0180oooo00<0o`000?ooo`3oool06@3oool0
1@000000j[Yb002Ke03oe9/0L[[Z01<0oooo0`00000K0?ooo`060=BK001b^^X0oooo0?ooe02K0000
VmCo<03oool01P3DV`0007:j0?ooo`3oool0j[Yb07:jjPD0oooo000=0?ooo`040>ZjLP0000000000
001b^S40oooo00@0^W80000000000000L[[Z7`3oool200000100oooo00<0e9/00000001b^^X0<@3o
ool00`000000oooo0?ooo`0B0?ooo`030?l0003oool0oooo01X0oooo00@000000=BK00000000L[[Z
5P3oool3000001T0oooo00@0^W80000000000000L[[Z<P3oool0103Z^W80000000000000L[X60?oo
o`00H`3oool2000004H0oooo00<000000?ooo`3oool04P3oool00`3o0000oooo0?ooo`0K0?ooo`03
0000003oool0oooo01T0oooo0`00001F0?ooo`00H@3oool2000004P0oooo00<000000?ooo`3oool0
4P3oool00`3o0000oooo0?ooo`0L0?ooo`030000003oool0oooo01/0oooo0P00001D0?ooo`00G`3o
ool2000004X0oooo0P00000C0?ooo`030?l0003oool0oooo01d0oooo00<000000?ooo`3oool0703o
ool300000540oooo001M0?ooo`800000C03oool00`000000oooo0?ooo`0B0?ooo`030?l0003oool0
oooo01h0oooo00<000000?ooo`3oool07P3oool3000004h0oooo001L0?ooo`030000003oool0oooo
04`0oooo00<000000?ooo`3oool04P3oool00`3o0000oooo0?ooo`0O0?ooo`030000003oool0oooo
0200oooo0P00001<0?ooo`00FP3oool2000004l0oooo00<000000?ooo`3oool04@3oool30?l00240
oooo00<000000?ooo`3oool08@3oool300000080oooo0`3o00140?ooo`00F03oool200000540oooo
00<000000?ooo`3oool0403oool50?l00240oooo00<000000?ooo`3oool08`3oool00`000000o`00
0?l000030?l004<0oooo000;0?oook<000001@3o0018000000D0o`00?00000070?ooo`002`3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo1@3o00080?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00P0oooo1@3o00000`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`002`3oool00`000000oooo0?ooo`0b0?oo
o`030000003oool0oooo0100oooo0P00000P0?ooo`030000003oool0oooo03<0oooo00<000000?oo
o`3oool04@3oool30?l001h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0S0?oo
o`<0o`000P3oool200000080oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`050?oo
o`00D@3oool2000005P0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0Z0?ooo`80
0000?P3oool004l0oooo0P00001J0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0
:`3oool3000003/0oooo001=0?ooo`800000G03oool00`000000oooo0?ooo`0j0?ooo`030000003o
ool0oooo02d0oooo0P00000i0?ooo`00B`3oool2000005h0oooo0P00000k0?ooo`030000003oool0
oooo02l0oooo0`00000f0?ooo`00B@3oool200000600oooo00<000000?ooo`3oool0>`3oool00`00
0000oooo0?ooo`0a0?ooo`<00000<`3oool004L0oooo0P00001R0?ooo`030000003oool0oooo03`0
oooo00<000000?ooo`3oool0<`3oool200000340oooo00150?ooo`800000I03oool00`000000oooo
0?ooo`0m0?ooo`030000003oool0oooo03@0oooo0`00000^0?ooo`00@`3oool2000006H0oooo00<0
00000?ooo`3oool0?@3oool00`000000oooo0?ooo`0g0?ooo`800000;03oool00400oooo0`00001X
0?ooo`800000?`3oool00`000000oooo0?ooo`0h0?ooo`<00000:@3oool003h0oooo0P00001[0?oo
o`030000003oool0oooo03l0oooo00<000000?ooo`3oool0>P3oool3000002H0oooo000k0?ooo`<0
0000K@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo03d0oooo0P00000T0?ooo`00
>03oool300000700oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0n0?ooo`<00000
8@3oool003H0oooo0P00001c0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool0@03o
ool3000001h0oooo000c0?ooo`<00000M@3oool00`000000oooo0?ooo`110?ooo`030000003oool0
oooo04<0oooo0P00000L0?ooo`002`3oool200000280oooo1000001h0?ooo`800000@`3oool00`00
0000oooo0?ooo`140?ooo`<000006@3oool000d0oooo0`00000L0?ooo`<00000O03oool00`000000
oooo0?ooo`130?ooo`030000003oool0oooo04H0oooo0`00000F0?ooo`00403oool6000000h0oooo
2000001o0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0B@3oool3000001<0oooo
000F0?ooo`h00000Q`3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo04/0oooo0P00
000A0?ooo`00Z`3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo04d0oooo0`00000>
0?ooo`00Z`3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo04l0oooo0`00000;0?oo
o`00Z`3oool2000004H0oooo00<000000?ooo`3oool0DP3oool2000000T0oooo002[0?ooo`030000
003oool0oooo04H0oooo00<000000?ooo`3oool0D`3oool2000000L0oooo002Q0?ooo`040;Yb0000
00000000001b^PH0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`1L0?ooo`00X03o
ool01P2jLP00L[[Z0?ooo`3oool0j[Yb002Ke0D0oooo00<000000?ooo`3oool0A`3oool00`000000
oooo0?ooo`1K0?ooo`00Y03oool00`3oom@0Vg:j0?ooo`040?ooo`030000003oool0oooo04L0oooo
00<000000?ooo`3oool0F`3oool00:@0oooo00<0omBK002Ke03oool0103oool3000004P0oooo00<0
00000?ooo`3oool0FP3oool00:00oooo00H0onZj07800000000000000000V`3Dool50?ooo`030000
003oool0oooo04P0oooo00<000000?ooo`3oool0FP3oool00:00oooo00<0onZj07:Ke03oool0203o
ool00`000000oooo0?ooo`190?ooo`030000003oool0oooo05T0oooo002P0?ooo`030?oZ^P1bVm@0
oooo00P0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`1H0?ooo`00X03oool01P3o
j[X0LP00000000000000002K0=Coo`D0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?oo
o`1H0?ooo`00Z`3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo05L0oooo002[0?oo
o`800000C03oool00`000000oooo0?ooo`1G0?ooo`00Z`3oool00`000000oooo0?ooo`1<0?ooo`03
0000003oool0oooo05H0oooo002[0?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool0
EP3oool00:/0oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`1E0?ooo`00Z`3oool0
0`000000oooo0?ooo`1=0?ooo`030000003oool0oooo05D0oooo002[0?ooo`030000003oool0oooo
04h0oooo00<000000?ooo`3oool0E03oool00:/0oooo0P00001?0?ooo`030000003oool0oooo05@0
oooo002[0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0D`3oool00:/0oooo00<0
00000?ooo`3oool0C`3oool00`000000oooo0?ooo`1C0?ooo`00Z`3oool00`000000oooo0?ooo`1@
0?ooo`030000003oool0oooo0580oooo002[0?ooo`030000003oool0oooo0500oooo00<000000?oo
o`3oool0DP3oool00:/0oooo0P00001B0?ooo`030000003oool0oooo0540oooo002[0?ooo`030000
003oool0oooo0540oooo00<000000?ooo`3oool0D@3oool00:/0oooo00<000000?ooo`3oool0DP3o
ool00`000000oooo0?ooo`1@0?ooo`00Z`3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0
oooo0500oooo002[0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0D03oool00:/0
oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`1?0?ooo`00Z`3oool2000005@0oooo
00<000000?ooo`3oool0C`3oool00:/0oooo00<000000?ooo`3oool0E03oool00`000000oooo0?oo
o`1>0?ooo`00Z`3oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo04h0oooo002H0?oo
o`030=BK0000000000000080000000D007:j0?ooo`3oool0oooo0;Yb000200000003002Ke03oool0
oooo00@0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1=0?ooo`00VP3oool00`3o
e9/0L[[Z0?ooo`030?ooo`060?oZ^P2K^^X0oooo0?ooo`3DV`00VmCo1@3oool00`000000oooo0?oo
o`1E0?ooo`030000003oool0oooo04d0oooo002J0?ooo`030?oDV`1b^^X0oooo00<0oooo00H0e9/0
09_Do`3oool0oooo0?oZ^P1bVm@50?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0
C03oool009X0oooo00<0omBK07:jjP3oool00`3oool01P3DVg80^^[o0?ooo`3oool0onZj079b^PD0
oooo0`00001F0?ooo`030000003oool0oooo04`0oooo002J0?ooo`030?oDV`1b^^X0oooo00<0oooo
00H0e9]b0;[Zo`3oool0oooo0?oZ^P1bL[X50?ooo`030000003oool0oooo05H0oooo00<000000?oo
o`3oool0C03oool009X0oooo00<0omBK07:jjP3oool00`3oool01P3DVg80^^[o0?ooo`3oool0onZj
07:Ke0D0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`1;0?ooo`00V03oool0103Z
^W8009_D0?oDV`1b^^X40?ooo`060?oDV`00L[X0oooo0?ooo`3DV`00VmCo1@3oool00`000000oooo
0?ooo`1G0?ooo`030000003oool0oooo04/0oooo002I0?ooo`030=BK00000000L[[Z00D0oooo00@0
j[Yb00000000000009_D1P3oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo04X0oooo
002[0?ooo`800000F@3oool00`000000oooo0?ooo`1:0?ooo`00Z`3oool00`000000oooo0?ooo`1I
0?ooo`030000003oool0oooo04T0oooo002[0?ooo`030000003oool0oooo05T0oooo00<000000?oo
o`3oool0B@3oool00:/0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`190?ooo`00
Z`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo04P0oooo002[0?ooo`030000003o
ool0oooo05X0oooo00<000000?ooo`3oool0B03oool00:/0oooo0P00001L0?ooo`030000003oool0
oooo04L0oooo002[0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool0A`3oool00:/0
oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`160?ooo`00Z`3oool00`000000oooo
0?ooo`1L0?ooo`030000003oool0oooo04H0oooo002[0?ooo`030000003oool0oooo05d0oooo00<0
00000?ooo`3oool0A@3oool00:/0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`15
0?ooo`00Z`3oool2000005h0oooo00<000000?ooo`3oool0A@3oool00:/0oooo00<000000?ooo`3o
ool0GP3oool00`000000oooo0?ooo`140?ooo`00Z`3oool00`000000oooo0?ooo`1N0?ooo`030000
003oool0oooo04@0oooo002[0?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool0A03o
ool00:/0oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`130?ooo`00Z`3oool20000
0600oooo00<000000?ooo`3oool0@`3oool00:/0oooo00<000000?ooo`3oool0G`3oool00`000000
oooo0?ooo`130?ooo`00Z`3oool00`000000oooo0?ooo`1P0?ooo`030000003oool0oooo0480oooo
002H0?ooo`030=BK0000000000000080000000D007:j0?ooo`3oool0oooo0;Yb000200000003001b
^P3oool0oooo00@0oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`120?ooo`00VP3o
ool00`3oe9/0L[[Z0?ooo`030?ooo`060;Yb001b^^X0oooo0?ooo`3Z^W8009_D1@3oool00`000000
oooo0?ooo`1P0?ooo`030000003oool0oooo0480oooo002J0?ooo`030?oDV`1b^^X0oooo00L0oooo
00<0oooD09]b^P3oool0103oool00`000000oooo0?ooo`1Q0?ooo`030000003oool0oooo0440oooo
002J0?ooo`030?oDV`1b^^X0oooo00L0oooo00<0omBK002Ke03oool0103oool300000640oooo00<0
00000?ooo`3oool0@@3oool009X0oooo00<0omBK07:jjP3oool00`3oool01P3oj[X0LP0000000000
0000002K0=Coojd0oooo002J0?ooo`030?oDV`1b^^X0oooo00<0oooo00<0onZj07:Ke03oool0/03o
ool009P0oooo00@0j[Yb002Ke03oe9/0L[[Z103oool00`3oj[X0LY_D0?ooo`2`0?ooo`00V@3oool0
0`3DV`00000007:jjP040?ooo`060?oZ^P1b000000000000000009/0e?oo[@3oool00?l0ooooE03o
ool00001\
\>"],
  ImageRangeCache->{{{0, 338.688}, {208.813, 0}} -> {-3.21374, -20.9967, 
  0.0234623, 0.22145}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.353162 0.0176581 [
[0 .34066 -6 -9 ]
[0 .34066 6 0 ]
[.16667 .34066 -6 -9 ]
[.16667 .34066 6 0 ]
[.33333 .34066 -6 -9 ]
[.33333 .34066 6 0 ]
[.66667 .34066 -3 -9 ]
[.66667 .34066 3 0 ]
[.83333 .34066 -3 -9 ]
[.83333 .34066 3 0 ]
[1 .34066 -3 -9 ]
[1 .34066 3 0 ]
[.4875 0 -18 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .08829 -18 -4.5 ]
[.4875 .08829 0 4.5 ]
[.4875 .17658 -18 -4.5 ]
[.4875 .17658 0 4.5 ]
[.4875 .26487 -12 -4.5 ]
[.4875 .26487 0 4.5 ]
[.4875 .44145 -6 -4.5 ]
[.4875 .44145 0 4.5 ]
[.4875 .52974 -12 -4.5 ]
[.4875 .52974 0 4.5 ]
[.4875 .61803 -12 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .35316 m
0 .35941 L
s
[(-3)] 0 .34066 0 1 Mshowa
.16667 .35316 m
.16667 .35941 L
s
[(-2)] .16667 .34066 0 1 Mshowa
.33333 .35316 m
.33333 .35941 L
s
[(-1)] .33333 .34066 0 1 Mshowa
.66667 .35316 m
.66667 .35941 L
s
[(1)] .66667 .34066 0 1 Mshowa
.83333 .35316 m
.83333 .35941 L
s
[(2)] .83333 .34066 0 1 Mshowa
1 .35316 m
1 .35941 L
s
[(3)] 1 .34066 0 1 Mshowa
.125 Mabswid
.03333 .35316 m
.03333 .35691 L
s
.06667 .35316 m
.06667 .35691 L
s
.1 .35316 m
.1 .35691 L
s
.13333 .35316 m
.13333 .35691 L
s
.2 .35316 m
.2 .35691 L
s
.23333 .35316 m
.23333 .35691 L
s
.26667 .35316 m
.26667 .35691 L
s
.3 .35316 m
.3 .35691 L
s
.36667 .35316 m
.36667 .35691 L
s
.4 .35316 m
.4 .35691 L
s
.43333 .35316 m
.43333 .35691 L
s
.46667 .35316 m
.46667 .35691 L
s
.53333 .35316 m
.53333 .35691 L
s
.56667 .35316 m
.56667 .35691 L
s
.6 .35316 m
.6 .35691 L
s
.63333 .35316 m
.63333 .35691 L
s
.7 .35316 m
.7 .35691 L
s
.73333 .35316 m
.73333 .35691 L
s
.76667 .35316 m
.76667 .35691 L
s
.8 .35316 m
.8 .35691 L
s
.86667 .35316 m
.86667 .35691 L
s
.9 .35316 m
.9 .35691 L
s
.93333 .35316 m
.93333 .35691 L
s
.96667 .35316 m
.96667 .35691 L
s
.25 Mabswid
0 .35316 m
1 .35316 L
s
.5 0 m
.50625 0 L
s
[(-20)] .4875 0 1 0 Mshowa
.5 .08829 m
.50625 .08829 L
s
[(-15)] .4875 .08829 1 0 Mshowa
.5 .17658 m
.50625 .17658 L
s
[(-10)] .4875 .17658 1 0 Mshowa
.5 .26487 m
.50625 .26487 L
s
[(-5)] .4875 .26487 1 0 Mshowa
.5 .44145 m
.50625 .44145 L
s
[(5)] .4875 .44145 1 0 Mshowa
.5 .52974 m
.50625 .52974 L
s
[(10)] .4875 .52974 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(15)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01766 m
.50375 .01766 L
s
.5 .03532 m
.50375 .03532 L
s
.5 .05297 m
.50375 .05297 L
s
.5 .07063 m
.50375 .07063 L
s
.5 .10595 m
.50375 .10595 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .14126 m
.50375 .14126 L
s
.5 .15892 m
.50375 .15892 L
s
.5 .19424 m
.50375 .19424 L
s
.5 .2119 m
.50375 .2119 L
s
.5 .22956 m
.50375 .22956 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .28253 m
.50375 .28253 L
s
.5 .30019 m
.50375 .30019 L
s
.5 .31785 m
.50375 .31785 L
s
.5 .3355 m
.50375 .3355 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .38848 m
.50375 .38848 L
s
.5 .40614 m
.50375 .40614 L
s
.5 .42379 m
.50375 .42379 L
s
.5 .45911 m
.50375 .45911 L
s
.5 .47677 m
.50375 .47677 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .51209 m
.50375 .51209 L
s
.5 .5474 m
.50375 .5474 L
s
.5 .56506 m
.50375 .56506 L
s
.5 .58272 m
.50375 .58272 L
s
.5 .60038 m
.50375 .60038 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 .40614 m
.00942 .40885 L
.01975 .4112 L
.02496 .41215 L
.03053 .41299 L
.03575 .41361 L
.04057 .41405 L
.04334 .41425 L
.04628 .41442 L
.0477 .41448 L
.04923 .41454 L
.0501 .41456 L
.0509 .41458 L
.05166 .4146 L
.05248 .41461 L
.05323 .41462 L
.05391 .41463 L
.05523 .41464 L
.05598 .41464 L
.05679 .41463 L
.05755 .41463 L
.05825 .41462 L
.05952 .4146 L
.06091 .41457 L
.06237 .41452 L
.06373 .41447 L
.06646 .41434 L
.06905 .41418 L
.0739 .41381 L
.07913 .41328 L
.08481 .41256 L
.09468 .41098 L
.10557 .40875 L
.12763 .40286 L
.16984 .38712 L
.21047 .3678 L
.25366 .3445 L
.29527 .32106 L
.33528 .29916 L
.37787 .27819 L
.41887 .26191 L
.44128 .25521 L
.45156 .25275 L
.46244 .2506 L
.47245 .24906 L
.47813 .24839 L
.48345 .24789 L
.48596 .2477 L
.48834 .24755 L
.4905 .24744 L
Mistroke
.4928 .24734 L
.4941 .2473 L
.49529 .24727 L
.49648 .24724 L
.4976 .24723 L
.49891 .24722 L
.50011 .24721 L
.50143 .24722 L
.5021 .24722 L
.50283 .24723 L
.50421 .24726 L
.50548 .24729 L
.50687 .24733 L
.50835 .24739 L
.51083 .24752 L
.51357 .24769 L
.51862 .24812 L
.52336 .24865 L
.53394 .25029 L
.54533 .25279 L
.55541 .25567 L
.56641 .25955 L
.58858 .26982 L
.60921 .28251 L
.63123 .29962 L
.67485 .34535 L
.71689 .40574 L
.75733 .48059 L
.80035 .57995 L
Mfstroke
.80035 .57995 m
.81389 .61803 L
s
.58026 0 m
.58254 .00602 L
.62583 .12003 L
.66752 .22985 L
.70762 .33548 L
.7503 .44789 L
.79139 .5561 L
s
.79139 .5561 m
.8149 .61803 L
s
1 0 0 r
.008 w
.56667 .35316 Mdot
.80652 .35316 Mdot
.71434 .35316 Mdot
.56667 .25964 Mdot
.80652 .59597 Mdot
.5 Mabswid
.80652 .35316 m
.80652 .59597 L
s
.016 w
.56667 .35316 Mdot
.80652 .35316 Mdot
.71434 .35316 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{273.063, 168.5},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005E0000dR000`400?l00000o`00003oo`3ooomF
0?ooo`00o`3ooomF0?ooo`00V03oool00`3oj[X0LP00000000030000000509_Do`3oool0oooo0?oo
o`2jLP000P0000000`00Vm@0oooo0?ooo`2]0?ooo`00V@3oool00`3DV`0007:j0?ooo`050?ooo`06
0?oZ^P2K^^X0oooo0?ooo`3DV`00VmCo[P3oool009X0oooo00<0j[Yb0000LP2jj_l0103oool01P3D
V`00VmCo0?ooo`3oool0onZj07:Ke:h0oooo002@0?ooo`030?ooe02K0000000000<0000000<0002K
0=Coo`3oool00P3oool00`3oj[X0LP0009_Do`030?ooo`060=BKLP2jj_l0oooo0?ooo`3oj[X0LW:j
1@3oool3000001H0oooo00<000000?ooo`3oool0S@3oool009`0oooo00<0oooD09]b^P3oool00P3o
ool01P3DVg80^^[o0?ooo`3oool0onZj079b^PD0oooo00<000000?ooo`3oool05P3oool00`000000
oooo0?ooo`2=0?ooo`00W@3oool01P3Z^W80VmCo0?ooo`3oool0e9]b0;[Zo`80oooo00<0onZj07:K
e03oool0103oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo08`0oooo002I0?ooo`06
0=BK001b^^X0oooo0?ooe02K0000VmCo0P3oool01P3oe9/007:j0?ooo`3oool0e9/009_Do`D0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`2<0?ooo`00VP3oool0102jLP0000000000
001b^^X40?ooo`040>ZjLP0000000000002Ke0H0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`2;0?ooo`00[03oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo08/0oooo
002/0?ooo`8000006P3oool00`000000oooo0?ooo`2:0?ooo`00[03oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo08X0oooo002/0?ooo`030000003oool0oooo01T0oooo00<000000?oo
o`3oool0RP3oool00:`0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`290?ooo`00
[03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo08T0oooo002/0?ooo`030000003o
ool0oooo01X0oooo00<000000?ooo`3oool0R@3oool00:`0oooo0P00000L0?ooo`030000003oool0
oooo08P0oooo002/0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0R03oool00:`0
oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`270?ooo`00[03oool00`000000oooo
0?ooo`0L0?ooo`030000003oool0oooo08L0oooo002/0?ooo`030000003oool0oooo01`0oooo00<0
00000?ooo`3oool0Q`3oool00:`0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`26
0?ooo`00[03oool2000001h0oooo00<000000?ooo`3oool0QP3oool00:`0oooo00<000000?ooo`3o
ool07@3oool00`000000oooo0?ooo`260?ooo`00[03oool00`000000oooo0?ooo`0N0?ooo`030000
003oool0oooo08D0oooo002/0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0Q@3o
ool00:`0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`240?ooo`00[03oool20000
0200oooo00<000000?ooo`3oool0Q03oool00:`0oooo00<000000?ooo`3oool07`3oool00`000000
oooo0?ooo`240?ooo`00[03oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo08<0oooo
002I0?ooo`030=BK0000000000000080000000D007:j0?ooo`3oool0oooo0;Yb000200000003001b
^P3oool0oooo00@0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`230?ooo`00V`3o
ool00`3oe9/0L[[Z0?ooo`030?ooo`060;Yb001b^^X0oooo0?ooo`3Z^W8009_D1@3oool00`000000
oooo0?ooo`0P0?ooo`030000003oool0oooo08<0oooo002K0?ooo`030?oDV`1b^^X0oooo00L0oooo
00<0oooD09]b^P3oool0103oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0880oooo
002@0?ooo`030?ooe02K0000000000<0000000<0002K0=Coo`3oool00P3oool00`3oe9/0L[[Z0?oo
o`070?ooo`030?oDV`00Vm@0oooo00@0oooo0`00000Q0?ooo`030000003oool0oooo0880oooo002K
0?ooo`030?oDV`1b^^X0oooo00<0oooo00H0onZj07800000000000000000V`3Dool50?ooo`030000
003oool0oooo0280oooo00<000000?ooo`3oool0P@3oool009/0oooo00<0omBK07:jjP3oool00`3o
ool00`3oj[X0LY_D0?ooo`080?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0P@3o
ool009T0oooo00@0j[Yb002Ke03oe9/0L[[Z103oool00`3oj[X0LY_D0?ooo`080?ooo`030000003o
ool0oooo0280oooo00<000000?ooo`3oool0P@3oool009X0oooo00<0e9/00000001b^^X0103oool0
1P3oj[X0LP00000000000000002K0=Coo`D0oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`200?ooo`00[03oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0800oooo002/
0?ooo`800000903oool00`000000oooo0?ooo`200?ooo`00[03oool00`000000oooo0?ooo`0T0?oo
o`030000003oool0oooo07l0oooo002/0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool0O`3oool00:`0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1n0?ooo`00[03o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo07h0oooo002/0?ooo`8000009P3oool0
0`000000oooo0?ooo`1n0?ooo`00[03oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
07d0oooo002/0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0O@3oool00:`0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`1m0?ooo`00[03oool00`000000oooo0?oo
o`0W0?ooo`030000003oool0oooo07`0oooo002/0?ooo`030000003oool0oooo02L0oooo00<00000
0?ooo`3oool0O03oool00:`0oooo0P00000Y0?ooo`030000003oool0oooo07/0oooo002/0?ooo`03
0000003oool0oooo02P0oooo00<000000?ooo`3oool0N`3oool00:`0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`1k0?ooo`00[03oool00`000000oooo0?ooo`0Y0?ooo`030000003o
ool0oooo07X0oooo002/0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0NP3oool0
0:`0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1j0?ooo`00[03oool2000002/0
oooo00<000000?ooo`3oool0N@3oool00:`0oooo00<000000?ooo`3oool0:P3oool00`000000oooo
0?ooo`1i0?ooo`00V@3oool00`3DV`0000000000000200000005001b^P3oool0oooo0?ooo`2jLP00
0P0000000`00Vm@0oooo0?ooo`040?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0
N03oool009/0oooo00<0omBK07:jjP3oool00`3oool01P3oj[X0Vk[Z0?ooo`3oool0e9/009_Do`D0
oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`1h0?ooo`00V`3oool00`3oe9/0L[[Z
0?ooo`030?ooo`060=BK002Ke?l0oooo0?ooo`3oj[X0LY_D1@3oool00`000000oooo0?ooo`0[0?oo
o`030000003oool0oooo07P0oooo002@0?ooo`030?ooe02K0000000000<0000000<0002K0=Coo`3o
ool00P3oool00`3oe9/0L[[Z0?ooo`030?ooo`060=BKLP2jj_l0oooo0?ooo`3oj[X0LW:j1@3oool3
000002`0oooo00<000000?ooo`3oool0M`3oool009/0oooo00<0omBK07:jjP3oool00`3oool01P3D
Vg80^^[o0?ooo`3oool0onZj079b^PD0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?oo
o`1g0?ooo`00V`3oool00`3oe9/0L[[Z0?ooo`030?ooo`060=BKLP2jj_l0oooo0?ooo`3oj[X0LY_D
1@3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo07L0oooo002I0?ooo`040>ZjLP00
Vm@0omBK07:jjP@0oooo00H0omBK001b^P3oool0oooo0=BK002Ke?l50?ooo`030000003oool0oooo
02d0oooo00<000000?ooo`3oool0MP3oool009X0oooo00<0e9/00000001b^^X01@3oool0103Z^W80
000000000000Vm@60?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0MP3oool00:`0
oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`1e0?ooo`00[03oool2000002l0oooo
00<000000?ooo`3oool0M@3oool00:`0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?oo
o`1e0?ooo`00[03oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo07@0oooo002/0?oo
o`030000003oool0oooo02l0oooo00<000000?ooo`3oool0M03oool00:`0oooo00<000000?ooo`3o
ool0;`3oool00`000000oooo0?ooo`1d0?ooo`00[03oool00`000000oooo0?ooo`0`0?ooo`030000
003oool0oooo07<0oooo002/0?ooo`800000<@3oool00`000000oooo0?ooo`1c0?ooo`00[03oool0
0`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0780oooo002/0?ooo`030000003oool0oooo
0340oooo00<000000?ooo`3oool0LP3oool00:`0oooo00<000000?ooo`3oool0<@3oool00`000000
oooo0?ooo`1b0?ooo`00[03oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo0740oooo
002/0?ooo`800000<`3oool00`000000oooo0?ooo`1a0?ooo`00[03oool00`000000oooo0?ooo`0b
0?ooo`030000003oool0oooo0740oooo002/0?ooo`030000003oool0oooo03<0oooo00<000000?oo
o`3oool0L03oool00:`0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`1`0?ooo`00
[03oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo06l0oooo002/0?ooo`030000003o
ool0oooo03@0oooo00<000000?ooo`3oool0K`3oool00:80oooo4`00000^0?ooo`030000003oool0
oooo06l0oooo002N0?ooo`@000002P3oool00`000000oooo0?ooo`060?ooo`<00000;03oool00`00
0000oooo0?ooo`1^0?ooo`00V03oool6000000h0oooo00<000000?ooo`3oool02@3oool4000002P0
oooo00<000000?ooo`3oool0KP3oool009H0oooo0P00000:0?ooo`040;Yb000000000000001b^PH0
oooo00<000000?ooo`3oool03@3oool3000002D0oooo00<000000?ooo`3oool0KP3oool009<0oooo
0`00000;0?ooo`060;Yb001b^^X0oooo0?ooo`3Z^W8009_D1@3oool00`000000oooo0?ooo`0@0?oo
o`040000003o0000000000000280oooo00<000000?ooo`3oool0K@3oool00900oooo0`00000B0?oo
o`030?ooe02KL[X0oooo00@0oooo00<000000?ooo`3oool04@3oool00`3o0000oooo0?ooo`020000
0200oooo00<000000?ooo`3oool0K@3oool008h0oooo0P0000080?ooo`030?ooe02K0000000000<0
000000<0002K0=Coo`3oool0103oool00`3oe9/009_D0?ooo`040?ooo`<000005P3oool2000001l0
oooo00<000000?ooo`3oool0K03oool008/0oooo0`00000C0?ooo`060?oZ^P1b0000000000000000
09/0e?oo1@3oool00`000000oooo0?ooo`0H0?ooo`8000007@3oool00`000000oooo0?ooo`1/0?oo
o`00R03oool3000001H0oooo00<0onZj07:Ke03oool0203oool00`000000oooo0?ooo`0J0?ooo`80
00006`3oool00`000000oooo0?ooo`1/0?ooo`00QP3oool2000001T0oooo00<0onZj07:Ke03oool0
203oool00`000000oooo0?ooo`0L0?ooo`8000006P3oool00`000000oooo0?ooo`1[0?ooo`00Q03o
ool2000001/0oooo00H0onZj07800000000000000000V`3Dool50?ooo`030000003oool0oooo01h0
oooo0P00000H0?ooo`030000003oool0oooo06/0oooo00220?ooo`800000:03oool200000240oooo
00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`1[0?ooo`00P03oool2000002X0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo06X0oooo001n
0?ooo`800000;03oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo01@0oooo00<00000
0?ooo`3oool0JP3oool007`0oooo0P00000^0?ooo`030000003oool0oooo02<0oooo0P00000E0?oo
o`030000003oool0oooo06T0oooo001j0?ooo`800000<03oool00`000000oooo0?ooo`0U0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool0J@3oool007P0oooo0P00000b0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`1Y0?ooo`00M`3o
ool00`000000oooo0?ooo`0b0?ooo`800000:03oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo06P0oooo001e0?ooo`800000=@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0J03oool000`0oooo00D0oooD09/0000000000000001b^P0`
0?ooo`030?oZ^P1b0000000000<0000000<0VmCo0?ooo`3oool0:@3oool200000080oooo00<0e9/0
0000000000000P0000000`00L[X0oooo0?ooo`0]0?ooo`030000003oool0oooo02T0oooo00<00000
0?ooo`3oool00`3oool00`3DV`0000000000000200000003001b^P3oool0oooo00D0oooo00<00000
0?ooo`3oool09@3oool00`3oj[X0LP00000000030000000309_Do`3oool0oooo02d0oooo00D0oooD
09/0000000000000001b^P070?ooo`00303oool01P2jLP00VmCo0?ooo`3oool0e9/0002Ke300oooo
00<0e9/0001b^P3oool0;03oool2000000H0oooo00<0omBK07:jjP3oool0<03oool00`000000oooo
0?ooo`0Z0?ooo`030000003oool0oooo00@0oooo00<0omBK07:jjP3oool0203oool00`000000oooo
0?ooo`0V0?ooo`030=BK0000L[X0oooo0380oooo00H0^W8009_Do`3oool0oooo0=BK0000Vm@60?oo
o`00403oool00`3oom@0Vg:j0?ooo`0`0?ooo`030>ZjLP000780^^[o02T0oooo0P0000080?ooo`03
0?oDV`1b^^X0oooo0300oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`030?ooo`03
0?oDV`1b^^X0oooo00P0oooo00<000000?ooo`3oool09`3oool00`3Z^W80001b0;[Zo`0e0?ooo`03
0?ooe02KL[X0oooo00D0oooo00030?ooo`030?ooe02K0000000000<0000000<0002K0=Coo`3oool0
103oool00`3DV`00L[[Z0?ooo`0V0?ooo`030?ooe02K0000000000<0000000<0002K0=Coo`3oool0
0P3oool00`3oj[X0LP0009_Do`0V0?ooo`80000000<0V`000000000000000P0000000`0009/0e?oo
0?ooo`020?ooo`030?oDV`1b^^X0oooo0300oooo00<000000?ooo`3oool0;03oool00`000000oooo
0?ooo`020?ooo`030?oDV`1b^^X0oooo00T0oooo00<000000?ooo`3oool09`3oool00`3oj[X0LP00
09_Do`0d0?ooo`030=BK001b^^X0oooo00D0oooo000=0?ooo`040?ooe02K00000000001b^S@0oooo
00<0oooD09]b^P3oool08`3oool2000000`0oooo00<0omBK07:jjP3oool0<03oool2000002h0oooo
00H000000?ooo`3oool0oooo0?oDV`1b^^X:0?ooo`030000003oool0oooo02P0oooo00<0oooD09]b
^P3oool0<03oool0103oom@0V`0000000000L[X70?ooo`00403oool00`3Z^W80L[[Z0?ooo`0c0?oo
o`030>ZjLP2Ke?l0oooo0240oooo00<000000?ooo`3oool0303oool00`3oe9/0L[[Z0?ooo`0`0?oo
o`030000003oool0oooo02h0oooo00D000000?ooo`3oool0omBK07:jjP0:0?ooo`030000003oool0
oooo02T0oooo00<0j[Yb09_Do`3oool0<P3oool00`3Z^W80L[[Z0?ooo`050?ooo`00303oool01P3D
V`0007:j0?ooo`3oool0j[Yb07:jjS00oooo00H0e9/007:jjP3oool0oooD09/0002Ke?lP0?ooo`80
00003@3oool0103Z^W8009_D0?oDV`1b^^Xa0?ooo`030000003oool0oooo02l0oooo00@00000002K
e03oe9/0L[[Z2`3oool00`000000oooo0?ooo`0T0?ooo`060=BK001b^^X0oooo0?ooe02K0000VmCo
;`3oool01P3DV`0007:j0?ooo`3oool0j[Yb07:jjPH0oooo000=0?ooo`040>ZjLP0000000000001b
^S80oooo00@0^W80000000000000L[[Z7`3oool200000100oooo00<0e9/00000001b^^X0<@3oool0
0`000000oooo0?ooo`0`0?ooo`80000000<0L[[Z0?ooo`3oool02@3oool00`000000oooo0?ooo`0U
0?ooo`040;Yb00000000000007:jjS40oooo00@0j[Yb00000000000007:j1`3oool006@0oooo0P00
00160?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`1T0?ooo`00HP3oool2000004P0oooo0P00000c0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool0I03oool00600oooo0P00001:0?ooo`030000003oool0oooo03<0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`1T0?ooo`00GP3oool2000004`0oooo00<000000?ooo`3o
ool0=03oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo06<0oooo001L0?ooo`800000
CP3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
H`3oool005X0oooo0P00001@0?ooo`030000003oool0oooo0140oooo0`3o000R0?ooo`030000003o
ool0oooo00L0oooo0`3o000K0?ooo`<0o`00A@3oool005P0oooo0P00001B0?ooo`030000003oool0
oooo0100oooo1@3o000Q0?ooo`030000003oool0oooo00H0oooo1@3o000I0?ooo`D0o`00A03oool0
00/0oooo]00000050?l002X000001@3o000I000000D0o`00?00000080?ooo`002`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`070?ooo`8000002P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01P3oool50?l000P0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?l000040?l000<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`D0
o`001P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool01P3oool000/0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo01l0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0A0?ooo`<0o`00
7P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo0`3o000K0?ooo`<0o`00
1`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo00H0oooo001B0?ooo`800000F03o
ool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool06P3o
ool00`3o0000oooo0?ooo`140?ooo`00D03oool2000005X0oooo00<000000?ooo`3oool0>P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo01T0oooo00<0o`000?ooo`3oool0A03oool0
04h0oooo0P00001L0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0I0?ooo`030?l0003oool0oooo04@0oooo001<0?ooo`800000GP3oool2000003`0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0H0?ooo`030?l0003oool0oooo04@0
oooo001:0?ooo`800000H03oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0603oool00`3o0000oooo0?ooo`140?ooo`00B03oool200000680oooo00<0
00000?ooo`3oool0?03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01P0oooo00<0
o`000?ooo`3oool0A03oool004H0oooo0P00001T0?ooo`030000003oool0oooo03d0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0G0?ooo`030?l0003oool0oooo04@0oooo00140?oo
o`800000IP3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool05`3oool00`3o0000oooo0?ooo`140?ooo`00@@3oool3000006P0oooo0P00000o0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool05P3oool00`3o0000oooo0?ooo`140?ooo`00
?P3oool3000006/0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo01H0oooo00<0o`000?ooo`3oool0A03oool003`0oooo0P00001^0?ooo`030000003o
ool0oooo03l0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0F0?ooo`030?l0003o
ool0oooo04@0oooo000i0?ooo`<00000L03oool00`000000oooo0?ooo`100?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool05@3oool00`3o0000oooo0?ooo`140?ooo`00=P3oool30000
07<0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
01D0oooo00<0o`000?ooo`3oool0A03oool003<0oooo0`00001f0?ooo`030000003oool0oooo0440
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0D0?ooo`030?l0003oool0oooo04@0
oooo000;0?ooo`8000008P3oool4000007T0oooo0P0000130?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0503oool00`3o0000oooo0?ooo`140?ooo`003@3oool5000001H0oooo1`00
001m0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0D0?ooo`030?l0003oool0oooo04@0oooo000B0?ooo`P000001P3oool8000008@0oooo00<00000
0?ooo`3oool0@`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo00<0o`00
0?ooo`3oool0A03oool001X0oooo1`00002;0?ooo`030000003oool0oooo04@0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0C0?ooo`030?l0003oool0oooo04@0oooo002/0?ooo`03
0000003oool0oooo04@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0C0?ooo`03
0?l0003oool0oooo04@0oooo002/0?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0B0?ooo`030?l0003oool0oooo04@0oooo002/0?ooo`800000AP3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0180oooo00<0o`000?ooo`3oool0A03o
ool00:`0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0140oooo00<0o`000?ooo`3oool0A03oool00:80oooo00@0^W8000000000000007:j1P3oool0
0`000000oooo0?ooo`160?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04@3oool0
0`3o0000oooo0?ooo`140?ooo`00X@3oool01P2jLP00L[[Z0?ooo`3oool0j[Yb002Ke0D0oooo00<0
00000?ooo`3oool0A`3oool01@000000oooo0?ooo`3oool0000001<0oooo00<0o`000?ooo`3oool0
A03oool00:D0oooo00<0oooD09]b^P3oool0103oool00`000000oooo0?ooo`170?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0403oool00`3o0000oooo0?ooo`140?ooo`00Y@3oool0
0`3oe9/009_D0?ooo`040?ooo`<00000B03oool01@000000oooo0?ooo`3oool000000180oooo00<0
o`000?ooo`3oool0A03oool00:40oooo00H0onZj07800000000000000000V`3Dool50?ooo`030000
003oool0oooo04P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`030?l0
003oool0oooo04@0oooo002Q0?ooo`030?oZ^P1bVm@0oooo00P0oooo00<000000?ooo`3oool0B@3o
ool01@000000oooo0?ooo`3oool000000140oooo00<0o`000?ooo`3oool0A03oool00:40oooo00<0
onZj07:Ke03oool0203oool00`000000oooo0?ooo`1:0?ooo`040000003oool0oooo00000140oooo
00<0o`000?ooo`3oool0A03oool00:40oooo00H0onZj07800000000000000000V`3Dool50?ooo`03
0000003oool0oooo04X0oooo00D000000?ooo`3oool0oooo0000000@0?ooo`030?l0003oool0oooo
04@0oooo002/0?ooo`030000003oool0oooo04/0oooo00@000000?ooo`3oool00000403oool00`3o
0000oooo0?ooo`140?ooo`00[03oool2000004`0oooo00@000000?ooo`3oool00000403oool00`3o
0000oooo0?ooo`140?ooo`00[03oool00`000000oooo0?ooo`1<0?ooo`040000003oool0oooo0000
00l0oooo00<0o`000?ooo`3oool0A03oool00:`0oooo00<000000?ooo`3oool0C03oool010000000
oooo0?ooo`00000?0?ooo`030?l0003oool0oooo04@0oooo002/0?ooo`030000003oool0oooo04d0
oooo00@000000?ooo`3oool000003P3oool00`3o0000oooo0?ooo`140?ooo`00[03oool00`000000
oooo0?ooo`1=0?ooo`040000003oool0oooo000000h0oooo00<0o`000?ooo`3oool0A03oool00:`0
oooo00<000000?ooo`3oool0CP3oool00`000000oooo0000000>0?ooo`030?l0003oool0oooo04@0
oooo002/0?ooo`800000C`3oool010000000oooo0?ooo`00000=0?ooo`030?l0003oool0oooo04@0
oooo002/0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`0000003@3oool00`3o0000oooo
0?ooo`140?ooo`00[03oool00`000000oooo0?ooo`1?0?ooo`030000003oool0000000d0oooo00<0
o`000?ooo`3oool0A03oool00:`0oooo00<000000?ooo`3oool0D03oool00`000000oooo0000000<
0?ooo`030?l0003oool0oooo04@0oooo002/0?ooo`030000003oool0oooo0500oooo00<000000?oo
o`000000303oool00`3o0000oooo0?ooo`140?ooo`00[03oool200000580oooo00<000000?ooo`00
00002`3oool00`3o0000oooo0?ooo`140?ooo`00[03oool00`000000oooo0?ooo`1A0?ooo`030000
003oool0000000/0oooo00<0o`000?ooo`3oool0A03oool00:`0oooo00<000000?ooo`3oool0DP3o
ool2000000/0oooo00<0o`000?ooo`3oool0A03oool00:`0oooo00<000000?ooo`3oool0DP3oool0
0`000000oooo0000000:0?ooo`030?l0003oool0oooo04@0oooo002/0?ooo`030000003oool0oooo
0580oooo00<000000?ooo`0000002P3oool00`3o0000oooo0?ooo`140?ooo`00[03oool00`000000
oooo0?ooo`1C0?ooo`8000002P3oool00`3o0000oooo0?ooo`140?ooo`00[03oool2000005@0oooo
00<000000?ooo`0000002@3oool00`3o0000oooo0?ooo`140?ooo`00[03oool00`000000oooo0?oo
o`1D0?ooo`8000002@3oool00`3o0000oooo0?ooo`140?ooo`00[03oool00`000000oooo0?ooo`1D
0?ooo`030000003oool0000000P0oooo00<0o`000?ooo`3oool0A03oool009T0oooo00<0e9/00000
000000000P0000001@00L[X0oooo0?ooo`3oool0^W800080000000<009_D0?ooo`3oool0103oool0
0`000000oooo0?ooo`1E0?ooo`800000203oool00`3o0000oooo0?ooo`140?ooo`00V`3oool00`3o
e9/0L[[Z0?ooo`030?ooo`060?oZ^P2K^^X0oooo0?ooo`3DV`00VmCo1@3oool00`000000oooo0?oo
o`1E0?ooo`800000203oool00`3o0000oooo0?ooo`140?ooo`00V`3oool00`3oe9/0L[[Z0?ooo`03
0?ooo`060=BK002Ke?l0oooo0?ooo`3oj[X0LY_D1@3oool00`000000oooo0?ooo`1F0?ooo`800000
1`3oool00`3o0000oooo0?ooo`140?ooo`00V`3oool00`3oe9/0L[[Z0?ooo`030?ooo`060=BKLP2j
j_l0oooo0?ooo`3oj[X0LW:j1@3oool3000005H0oooo0P0000070?ooo`030?l0003oool0oooo04@0
oooo002K0?ooo`030?oDV`1b^^X0oooo00<0oooo00H0e9]b0;[Zo`3oool0oooo0?oZ^P1bL[X50?oo
o`030000003oool0oooo05H0oooo0P0000070?ooo`030?l0003oool0oooo04@0oooo002K0?ooo`03
0?oDV`1b^^X0oooo00<0oooo00H0e9]b0;[Zo`3oool0oooo0?oZ^P1bVm@50?ooo`030000003oool0
oooo05L0oooo0P0000060?ooo`030?l0003oool0oooo04@0oooo002I0?ooo`040>ZjLP00Vm@0omBK
07:jjP@0oooo00H0omBK001b^P3oool0oooo0=BK002Ke?l50?ooo`030000003oool0oooo05L0oooo
0P0000060?ooo`030?l0003oool0oooo04@0oooo002J0?ooo`030=BK00000000L[[Z00D0oooo00@0
j[Yb00000000000009_D1P3oool00`000000oooo0?ooo`1H0?ooo`8000001@3oool00`3o0000oooo
0?ooo`140?ooo`00[03oool2000005T0oooo0P0000050?ooo`030?l0003oool0oooo04@0oooo002/
0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool00`3oool00`3o0000oooo0?ooo`14
0?ooo`00[03oool00`000000oooo0?ooo`1I0?ooo`800000103oool00`3o0000oooo0?ooo`140?oo
o`00[03oool00`000000oooo0?ooo`1I0?ooo`800000103oool00`3o0000oooo0?ooo`140?ooo`00
[03oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo0080oooo00<0o`000?ooo`3oool0
A03oool00:`0oooo00<000000?ooo`3oool0FP3oool2000000<0oooo00<0o`000?ooo`3oool0A03o
ool00:`0oooo0P00001L0?ooo`050000003oool0oooo0?ooo`3o0000AP3oool00:`0oooo00<00000
0?ooo`3oool0F`3oool200000080oooo00<0o`000?ooo`3oool0A03oool00:`0oooo00<000000?oo
o`3oool0G03oool010000000oooo0?ooo`3o00160?ooo`00[03oool00`000000oooo0?ooo`1L0?oo
o`040000003oool0oooo0?l004H0oooo002/0?ooo`030000003oool0oooo05d0oooo00<000000?oo
o`3o0000AP3oool00:`0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?l000160?ooo`00
[03oool2000005h0oooo0P0000000`3o0000oooo0?ooo`140?ooo`00[03oool00`000000oooo0?oo
o`1N0?ooo`030000003o0000oooo04D0oooo002/0?ooo`030000003oool0oooo05h0oooo00<00000
0?l0003oool0A@3oool00:`0oooo00<000000?ooo`3oool0GP3oool00`000000o`000?ooo`150?oo
o`00[03oool00`000000oooo0?ooo`1N0?ooo`80o`00AP3oool00:`0oooo0P00001O0?ooo`030?l0
00000000000004D0oooo002/0?ooo`030000003oool0oooo05l0oooo0P0000150?ooo`00[03oool0
0`000000oooo0?ooo`1P0?ooo`030000003oool0oooo04<0oooo002I0?ooo`030=BK000000000000
0080000000D007:j0?ooo`3oool0oooo0;Yb000200000003001b^P3oool0oooo00@0oooo00<00000
0?ooo`3oool0H03oool2000004@0oooo002K0?ooo`030?oDV`1b^^X0oooo00<0oooo00H0^W8007:j
jP3oool0oooo0>ZjLP00Vm@50?ooo`030000003oool0oooo0600oooo0P0000140?ooo`00V`3oool0
0`3oe9/0L[[Z0?ooo`070?ooo`030?ooe02KL[X0oooo00@0oooo00<000000?ooo`3oool0H@3oool2
000004<0oooo002K0?ooo`030?oDV`1b^^X0oooo00L0oooo00<0omBK002Ke03oool0103oool30000
0640oooo0P0000130?ooo`00V`3oool00`3oe9/0L[[Z0?ooo`030?ooo`060?oZ^P1b000000000000
000009/0e?oo[P3oool009/0oooo00<0omBK07:jjP3oool00`3oool00`3oj[X0LY_D0?ooo`2a0?oo
o`00V@3oool0103Z^W8009_D0?oDV`1b^^X40?ooo`030?oZ^P1bVm@0oooo0;40oooo002J0?ooo`03
0=BK00000000L[[Z00@0oooo00H0onZj07800000000000000000V`3Doon^0?ooo`00o`3ooomF0?oo
o`00\
\>"],
  ImageRangeCache->{{{0, 340.313}, {209.625, 0}} -> {-3.21577, -20.9926, 
  0.0233662, 0.220543}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.353162 0.0176581 [
[0 .34066 -6 -9 ]
[0 .34066 6 0 ]
[.16667 .34066 -6 -9 ]
[.16667 .34066 6 0 ]
[.33333 .34066 -6 -9 ]
[.33333 .34066 6 0 ]
[.66667 .34066 -3 -9 ]
[.66667 .34066 3 0 ]
[.83333 .34066 -3 -9 ]
[.83333 .34066 3 0 ]
[1 .34066 -3 -9 ]
[1 .34066 3 0 ]
[.4875 0 -18 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .08829 -18 -4.5 ]
[.4875 .08829 0 4.5 ]
[.4875 .17658 -18 -4.5 ]
[.4875 .17658 0 4.5 ]
[.4875 .26487 -12 -4.5 ]
[.4875 .26487 0 4.5 ]
[.4875 .44145 -6 -4.5 ]
[.4875 .44145 0 4.5 ]
[.4875 .52974 -12 -4.5 ]
[.4875 .52974 0 4.5 ]
[.4875 .61803 -12 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .35316 m
0 .35941 L
s
[(-3)] 0 .34066 0 1 Mshowa
.16667 .35316 m
.16667 .35941 L
s
[(-2)] .16667 .34066 0 1 Mshowa
.33333 .35316 m
.33333 .35941 L
s
[(-1)] .33333 .34066 0 1 Mshowa
.66667 .35316 m
.66667 .35941 L
s
[(1)] .66667 .34066 0 1 Mshowa
.83333 .35316 m
.83333 .35941 L
s
[(2)] .83333 .34066 0 1 Mshowa
1 .35316 m
1 .35941 L
s
[(3)] 1 .34066 0 1 Mshowa
.125 Mabswid
.03333 .35316 m
.03333 .35691 L
s
.06667 .35316 m
.06667 .35691 L
s
.1 .35316 m
.1 .35691 L
s
.13333 .35316 m
.13333 .35691 L
s
.2 .35316 m
.2 .35691 L
s
.23333 .35316 m
.23333 .35691 L
s
.26667 .35316 m
.26667 .35691 L
s
.3 .35316 m
.3 .35691 L
s
.36667 .35316 m
.36667 .35691 L
s
.4 .35316 m
.4 .35691 L
s
.43333 .35316 m
.43333 .35691 L
s
.46667 .35316 m
.46667 .35691 L
s
.53333 .35316 m
.53333 .35691 L
s
.56667 .35316 m
.56667 .35691 L
s
.6 .35316 m
.6 .35691 L
s
.63333 .35316 m
.63333 .35691 L
s
.7 .35316 m
.7 .35691 L
s
.73333 .35316 m
.73333 .35691 L
s
.76667 .35316 m
.76667 .35691 L
s
.8 .35316 m
.8 .35691 L
s
.86667 .35316 m
.86667 .35691 L
s
.9 .35316 m
.9 .35691 L
s
.93333 .35316 m
.93333 .35691 L
s
.96667 .35316 m
.96667 .35691 L
s
.25 Mabswid
0 .35316 m
1 .35316 L
s
.5 0 m
.50625 0 L
s
[(-20)] .4875 0 1 0 Mshowa
.5 .08829 m
.50625 .08829 L
s
[(-15)] .4875 .08829 1 0 Mshowa
.5 .17658 m
.50625 .17658 L
s
[(-10)] .4875 .17658 1 0 Mshowa
.5 .26487 m
.50625 .26487 L
s
[(-5)] .4875 .26487 1 0 Mshowa
.5 .44145 m
.50625 .44145 L
s
[(5)] .4875 .44145 1 0 Mshowa
.5 .52974 m
.50625 .52974 L
s
[(10)] .4875 .52974 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(15)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01766 m
.50375 .01766 L
s
.5 .03532 m
.50375 .03532 L
s
.5 .05297 m
.50375 .05297 L
s
.5 .07063 m
.50375 .07063 L
s
.5 .10595 m
.50375 .10595 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .14126 m
.50375 .14126 L
s
.5 .15892 m
.50375 .15892 L
s
.5 .19424 m
.50375 .19424 L
s
.5 .2119 m
.50375 .2119 L
s
.5 .22956 m
.50375 .22956 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .28253 m
.50375 .28253 L
s
.5 .30019 m
.50375 .30019 L
s
.5 .31785 m
.50375 .31785 L
s
.5 .3355 m
.50375 .3355 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .38848 m
.50375 .38848 L
s
.5 .40614 m
.50375 .40614 L
s
.5 .42379 m
.50375 .42379 L
s
.5 .45911 m
.50375 .45911 L
s
.5 .47677 m
.50375 .47677 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .51209 m
.50375 .51209 L
s
.5 .5474 m
.50375 .5474 L
s
.5 .56506 m
.50375 .56506 L
s
.5 .58272 m
.50375 .58272 L
s
.5 .60038 m
.50375 .60038 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 .40614 m
.00942 .40885 L
.01975 .4112 L
.02496 .41215 L
.03053 .41299 L
.03575 .41361 L
.04057 .41405 L
.04334 .41425 L
.04628 .41442 L
.0477 .41448 L
.04923 .41454 L
.0501 .41456 L
.0509 .41458 L
.05166 .4146 L
.05248 .41461 L
.05323 .41462 L
.05391 .41463 L
.05523 .41464 L
.05598 .41464 L
.05679 .41463 L
.05755 .41463 L
.05825 .41462 L
.05952 .4146 L
.06091 .41457 L
.06237 .41452 L
.06373 .41447 L
.06646 .41434 L
.06905 .41418 L
.0739 .41381 L
.07913 .41328 L
.08481 .41256 L
.09468 .41098 L
.10557 .40875 L
.12763 .40286 L
.16984 .38712 L
.21047 .3678 L
.25366 .3445 L
.29527 .32106 L
.33528 .29916 L
.37787 .27819 L
.41887 .26191 L
.44128 .25521 L
.45156 .25275 L
.46244 .2506 L
.47245 .24906 L
.47813 .24839 L
.48345 .24789 L
.48596 .2477 L
.48834 .24755 L
.4905 .24744 L
Mistroke
.4928 .24734 L
.4941 .2473 L
.49529 .24727 L
.49648 .24724 L
.4976 .24723 L
.49891 .24722 L
.50011 .24721 L
.50143 .24722 L
.5021 .24722 L
.50283 .24723 L
.50421 .24726 L
.50548 .24729 L
.50687 .24733 L
.50835 .24739 L
.51083 .24752 L
.51357 .24769 L
.51862 .24812 L
.52336 .24865 L
.53394 .25029 L
.54533 .25279 L
.55541 .25567 L
.56641 .25955 L
.58858 .26982 L
.60921 .28251 L
.63123 .29962 L
.67485 .34535 L
.71689 .40574 L
.75733 .48059 L
.80035 .57995 L
Mfstroke
.80035 .57995 m
.81389 .61803 L
s
.46578 0 m
.49953 .05452 L
.54183 .12287 L
.58254 .18864 L
.62583 .25858 L
.66752 .32595 L
.70762 .39074 L
.7503 .45969 L
.79139 .52608 L
.83505 .59662 L
s
.83505 .59662 m
.8483 .61803 L
s
1 0 0 r
.008 w
.56667 .35316 Mdot
.80652 .35316 Mdot
.71434 .35316 Mdot
.68437 .35316 Mdot
.56667 .25964 Mdot
.80652 .59597 Mdot
.71434 .40159 Mdot
.5 Mabswid
.71434 .35316 m
.71434 .40159 L
s
.016 w
.56667 .35316 Mdot
.80652 .35316 Mdot
.71434 .35316 Mdot
.68437 .35316 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{276.938, 170.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005J0000eB000`400?l00000o`00003oo`3ooomK
0?ooo`00o`3ooomK0?ooo`00VP3oool00`3oj[X0LP00000000030000000509_Do`3oool0oooo0?oo
o`2jLP000P0000000`00Vm@0oooo0?ooo`2`0?ooo`00V`3oool00`3DV`0007:j0?ooo`050?ooo`06
0?oZ^P2K^^X0oooo0?ooo`3DV`00VmCo/@3oool009`0oooo00<0j[Yb0000LP2jj_l0103oool01P3D
V`00VmCo0?ooo`3oool0onZj07:Ke;40oooo002B0?ooo`030?ooe02K0000000000<0000000<0002K
0=Coo`3oool00P3oool00`3oj[X0LP0009_Do`030?ooo`060000002jj_l0oooo0?ooo`3oj[X0LW:j
1@3oool300000:T0oooo002N0?ooo`030?ooe02KL[X0oooo0080oooo00H0e9]b0000003oool0oooo
0?oZ^P1bL[X50?ooo`030000003oool0oooo0:T0oooo002O0?ooo`060>ZjLP2Ke?l0oooo0?ooo`3D
Vg8000000P3oool00`3oj[X0LY_D0?ooo`040?ooo`030000003oool0oooo0:T0oooo002K0?ooo`06
0=BK001b^^X0oooo0?ooe02K0000VmCo0P3oool01P3oe9/007:j0000003oool0e9/009_Do`D0oooo
00<000000?ooo`3oool0Z@3oool009`0oooo00@0^W80000000000000L[[Z103oool0103Z^W800000
00000000Vm@60?ooo`030000003oool0oooo0:T0oooo002V0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0Z@3oool00:L0oooo00<000000?ooo`3oool0103oool200000:X0oooo002W
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0Z@3oool00:P0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`2Y0?ooo`00Z03oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0:T0oooo002Y0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
Z@3oool00:X0oooo00D000000?ooo`3oool0oooo0000002[0?ooo`00ZP3oool010000000oooo0?oo
o`3oool200000:X0oooo002[0?ooo`040000003oool0oooo00000:/0oooo002/0?ooo`030000003o
ool000000:/0oooo002/0?ooo`030000003oool000000:/0oooo002]0?ooo`800000Z`3oool00:d0
oooo0P00002[0?ooo`00[P3oool200000:X0oooo002^0?ooo`800000ZP3oool00:h0oooo0P00002Z
0?ooo`00[P3oool00`000000oooo0000002Y0?ooo`00[P3oool00`000000oooo0000002Y0?ooo`00
[P3oool010000000oooo0?ooo`00002X0?ooo`00[P3oool200000080oooo00<000000?ooo`3oool0
Y@3oool00:h0oooo00D000000?ooo`3oool0oooo0000002W0?ooo`00V`3oool00`3DV`0000000000
000200000005001b^P3oool0oooo0?ooo`2jLP000P0000000`00L[X0oooo0?ooo`040?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0Y03oool009d0oooo00<0omBK07:jjP3oool00`3o
ool01P2jLP00L[[Z0?ooo`3oool0j[Yb002Ke0D0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`2T0?ooo`00W@3oool00`3oe9/0L[[Z0?ooo`070?ooo`030?ooe02KL[X0oooo00@0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2S0?ooo`00TP3oool00`3oom@0V`000000
0003000000030000V`3Dool0oooo0080oooo00<0omBK07:jjP3oool01`3oool00`3oe9/009_D0?oo
o`040?ooo`<00000103oool00`000000oooo0?ooo`2R0?ooo`00W@3oool00`3oe9/0L[[Z0?ooo`03
0?ooo`060?oZ^P1b000000000000000009/0e?oo1@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0:80oooo002M0?ooo`030?oDV`1b^^X0oooo00<0oooo00<0onZj07:Ke03oool0203o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0:40oooo002K0?ooo`040>ZjLP00Vm@0
omBK07:jjP@0oooo00<0onZj07:Ke03oool0203oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo0:00oooo002L0?ooo`030=BK00000000L[[Z00@0oooo00H0onZj07800000000000000000
V`3Dool50?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0X03oool00:h0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`2O0?ooo`00[P3oool2000000P0oooo00<00000
0?ooo`3oool0W`3oool00:h0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`2N0?oo
o`00[P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo09d0oooo002^0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0W@3oool00:h0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`2L0?ooo`00[P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo09`0oooo002^0?ooo`800000303oool00`000000oooo0?ooo`2K0?ooo`00[P3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo09X0oooo002^0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0VP3oool00:h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`2I0?ooo`00[P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo09T0oooo002^0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool0V03oool00:h0oooo0P00000@0?ooo`03
0000003oool0oooo09L0oooo002^0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
U`3oool00:h0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`2F0?ooo`00[P3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo09D0oooo002^0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool0U@3oool00:h0oooo0P00000C0?ooo`030000003oool0oooo09@0
oooo002^0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0U03oool00:h0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`2C0?ooo`00V`3oool00`3DV`00000000000002
00000005001b^P3oool0oooo0?ooo`2jLP000P0000000`00Vm@0oooo0?ooo`040?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool0TP3oool009d0oooo00<0omBK07:jjP3oool00`3oool0
1P3oj[X0Vk[Z0?ooo`3oool0e9/009_Do`D0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`2B0?ooo`00W@3oool00`3oe9/0L[[Z0?ooo`030?ooo`060=BK002Ke?l0oooo0?ooo`3oj[X0
LY_D1@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0940oooo002B0?ooo`030?oo
e02K0000000000<0000000<0002K0=Coo`3oool00P3oool00`3oe9/0L[[Z0?ooo`030?ooo`060=BK
LP2jj_l0oooo0?ooo`3oj[X0LW:j1@3oool3000001H0oooo00<000000?ooo`3oool0T03oool009d0
oooo00<0omBK07:jjP3oool00`3oool01P3DVg80^^[o0?ooo`3oool0onZj079b^PD0oooo00<00000
0?ooo`3oool05P3oool00`000000oooo0?ooo`2@0?ooo`00W@3oool00`3oe9/0L[[Z0?ooo`030?oo
o`060=BKLP2jj_l0oooo0?ooo`3oj[X0LY_D1@3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo08l0oooo002K0?ooo`040>ZjLP00Vm@0omBK07:jjP@0oooo00H0omBK001b^P3oool0oooo
0=BK002Ke?l50?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0S`3oool009`0oooo
00<0e9/00000001b^^X01@3oool0103Z^W80000000000000Vm@60?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0SP3oool00:h0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`2=0?ooo`00[P3oool2000001X0oooo00<000000?ooo`3oool0S@3oool00:h0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`2<0?ooo`00[P3oool00`000000oooo0?ooo`0J0?oo
o`030000003oool0oooo08`0oooo002^0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3o
ool0R`3oool00:h0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`2:0?ooo`00[P3o
ool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo08X0oooo002^0?ooo`8000007P3oool0
0`000000oooo0?ooo`290?ooo`00[P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo
08T0oooo002^0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0R03oool00:h0oooo
00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`270?ooo`00[P3oool00`000000oooo0?oo
o`0O0?ooo`030000003oool0oooo08L0oooo002^0?ooo`8000008@3oool00`000000oooo0?ooo`26
0?ooo`00[P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo08D0oooo002^0?ooo`03
0000003oool0oooo0240oooo00<000000?ooo`3oool0Q@3oool00:h0oooo00<000000?ooo`3oool0
8P3oool00`000000oooo0?ooo`240?ooo`00[P3oool00`000000oooo0?ooo`0R0?ooo`030000003o
ool0oooo08@0oooo002^0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0P`3oool0
0:L0oooo3P00000P0?ooo`030000003oool0oooo0880oooo002Q0?ooo`H000001`3oool00`000000
oooo0?ooo`040?ooo`H000006P3oool00`000000oooo0?ooo`220?ooo`00W@3oool4000000d0oooo
00<000000?ooo`3oool02P3oool4000001L0oooo00<000000?ooo`3oool0P@3oool009X0oooo0`00
00070?ooo`040;Yb000000000000001b^PH0oooo00<000000?ooo`3oool03P3oool3000001@0oooo
00<000000?ooo`3oool0P@3oool009H0oooo100000090?ooo`060;Yb001b^^X0oooo0?ooo`3Z^W80
09_D1@3oool00`000000oooo0?ooo`0A0?ooo`040000003o0000000000000140oooo00<000000?oo
o`3oool0P03oool009<0oooo0`00000A0?ooo`030?ooe02KL[X0oooo00@0oooo00<000000?ooo`3o
ool04P3oool00`3o0000oooo0?ooo`0200000100oooo00<000000?ooo`3oool0O`3oool00900oooo
0`0000070?ooo`030?ooe02K0000000000<0000000<0002K0=Coo`3oool0103oool00`3oe9/009_D
0?ooo`040?ooo`<000005`3oool2000000h0oooo00<000000?ooo`3oool0O`3oool008h0oooo0P00
000C0?ooo`060?oZ^P1b000000000000000009/0e?oo1@3oool00`000000oooo0?ooo`0I0?ooo`80
00003@3oool00`000000oooo0?ooo`1n0?ooo`00R`3oool3000001D0oooo00<0onZj07:Ke03oool0
203oool00`000000oooo0?ooo`0K0?ooo`800000303oool00`000000oooo0?ooo`1m0?ooo`00R03o
ool3000001P0oooo00<0onZj07:Ke03oool0203oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0O@3oool008H0oooo0P00000K0?ooo`060?oZ^P1b0000
00000000000009/0e?oo1@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0O03oool008@0oooo0P00000X0?ooo`030000003oool0oooo01l0oooo0P00
00090?ooo`030000003oool0oooo07`0oooo00220?ooo`800000:P3oool200000280oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`1k0?ooo`00P03oool2000002`0oooo00<000000?oo
o`3oool08P3oool2000000P0oooo00<000000?ooo`3oool0NP3oool007h0oooo0P00000^0?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1j0?ooo`00
O03oool200000300oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo07T0oooo001j0?ooo`800000<P3oool00`000000oooo0?ooo`0V0?ooo`8000001P3o
ool00`000000oooo0?ooo`1h0?ooo`00N03oool2000003@0oooo0P00000Y0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0N03oool007H0oooo0P00000f0?ooo`030000003oool0oooo
02T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1g0?ooo`00303oool01@3oom@0
V`0000000000000007:j0300oooo00<0onZj0780000000000`0000000`2Ke?l0oooo0?ooo`0Z0?oo
o`8000000`3oool00`3DV`0000000000000200000003001b^P3oool0oooo02d0oooo00<000000?oo
o`3oool0:P3oool00`000000oooo0?ooo`030?ooo`D0000000<007:j0?ooo`3oool0;P3oool00`3o
j[X0LP00000000030000000309_Do`3oool0oooo02h0oooo00D0oooD09/0000000000000001b^P07
0?ooo`00303oool01P2jLP00VmCo0?ooo`3oool0e9/0002Ke300oooo00<0e9/0001b^P3oool0;@3o
ool2000000L0oooo00<0omBK07:jjP3oool0<03oool00`000000oooo0?ooo`0[0?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oe9/0L[[Z<`3oool00`3DV`0007:j0?ooo`0c0?ooo`060;Yb
002Ke?l0oooo0?ooo`3DV`0009_D1P3oool00100oooo00<0oooD09]b^P3oool0<03oool00`3Z^W80
001b0;[Zo`0Z0?ooo`8000002@3oool00`3oe9/0L[[Z0?ooo`0`0?ooo`030000003oool0oooo02`0
oooo00<000000?ooo`3oool00P3oool00`000000omBK07:jjP0d0?ooo`030>ZjLP000780^^[o03H0
oooo00<0oooD09]b^P3oool01@3oool000<0oooo00<0oooD09/0000000000`0000000`0009/0e?oo
0?ooo`040?ooo`030=BK001b^^X0oooo02H0oooo00<0oooD09/0000000000`0000000`0009/0e?oo
0?ooo`020?ooo`030?oZ^P1b0000VmCo02L0oooo0P0000000`3oom@0V`0000000003000000030000
V`3Dool0oooo0080oooo00<0omBK07:jjP3oool0<03oool00`000000oooo0?ooo`0]0?ooo`070000
003oool0oooo0?ooo`000000omBK07:jjP0e0?ooo`030?oZ^P1b0000VmCo03D0oooo00<0e9/007:j
jP3oool01@3oool000d0oooo00@0oooD09/00000000007:j=03oool00`3oom@0Vg:j0?ooo`0T0?oo
o`8000003@3oool00`3oe9/0L[[Z0?ooo`0`0?ooo`800000;`3oool01P000000oooo0?ooo`3oool0
000007:jjSH0oooo00<0oooD09]b^P3oool0<@3oool0103oom@0V`0000000000L[X70?ooo`00403o
ool00`3Z^W80L[[Z0?ooo`0c0?ooo`030>ZjLP2Ke?l0oooo0280oooo00<000000?ooo`3oool03@3o
ool00`3oe9/0L[[Z0?ooo`0`0?ooo`030000003oool0oooo02l0oooo00D000000?ooo`3oool0omBK
0000000g0?ooo`030>ZjLP2Ke?l0oooo03<0oooo00<0j[Yb07:jjP3oool01@3oool000`0oooo00H0
e9/0001b^P3oool0oooo0>ZjLP1b^^X`0?ooo`060=BK001b^^X0oooo0?ooe02K0000VmCo8@3oool2
000000h0oooo00@0j[Yb002Ke03oe9/0L[[Z<@3oool00`000000oooo0?ooo`0_0?ooo`050000003Z
^W8009_D0?oDV`000000<`3oool01P3DV`00L[[Z0?ooo`3oom@0V`0009_Doc00oooo00H0e9/0001b
^P3oool0oooo0>ZjLP1b^^X60?ooo`003@3oool0103Z^W80000000000000L[Xb0?ooo`040;Yb0000
0000000007:jjR00oooo0P00000A0?ooo`030=BK00000000L[[Z0340oooo00<000000?ooo`3oool0
<03oool01@000000e9/00000001b^^X0000003<0oooo00@0^W80000000000000L[[Z<P3oool0103Z
^W80000000000000L[X70?ooo`00IP3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo
0340oooo00D000000?ooo`3oool0oooo0000001c0?ooo`00I03oool2000004P0oooo00<000000?oo
o`3oool0<P3oool010000000oooo0?ooo`00001c0?ooo`00H`3oool00`000000oooo0?ooo`180?oo
o`800000=03oool010000000oooo0?ooo`00001b0?ooo`00H@3oool2000004/0oooo00<000000?oo
o`3oool0=03oool00`000000oooo0000001b0?ooo`00G`3oool2000004d0oooo00<000000?ooo`3o
ool0=@3oool00`000000oooo0000001a0?ooo`00GP3oool00`000000oooo0?ooo`1=0?ooo`030000
003oool0oooo03H0oooo00<000000?ooo`000000L03oool005`0oooo0P00001@0?ooo`030000003o
ool0oooo0180oooo0`3o000R0?ooo`040000003o0000o`000?l000L0oooo0`3o000K0?ooo`<0o`00
AP3oool005X0oooo0P00001B0?ooo`030000003oool0oooo0140oooo1@3o000Q0?ooo`D0o`001@3o
ool50?l001T0oooo1@3o00150?ooo`002`3ooong000000D0o`008@0000050?l000D000001@3o000I
000000D0o`00?@0000080?ooo`002`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`8000002P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool50?l0
00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`040000003oool0oooo
0?ooo`D0o`000P3oool00`000000oooo0?ooo`050?l000<0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`080?ooo`D0o`001P3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool01P3oool000/0oooo00<000000?ooo`3oool0<`3oool00`00
0000oooo0?ooo`0@0?ooo`8000008P3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo
0180oooo0`3o000N0?ooo`030000003oool0oooo0080oooo0`3o00000`000000oooo0?ooo`040?oo
o`<0o`006`3oool30?l000L0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`060?oo
o`00DP3oool2000005X0oooo00<000000?ooo`3oool0>P3oool2000000L0oooo00<0o`000?ooo`3o
ool0H`3oool00500oooo0P00001L0?ooo`030000003oool0oooo03/0oooo0P0000060?ooo`030?l0
003oool0oooo06<0oooo001>0?ooo`800000GP3oool2000003d0oooo0P0000050?ooo`030?l0003o
ool0oooo06<0oooo001<0?ooo`800000H03oool00`000000oooo0?ooo`0l0?ooo`8000001@3oool0
0`3o0000oooo0?ooo`1S0?ooo`00BP3oool200000680oooo00<000000?ooo`3oool0?@3oool20000
00@0oooo00<0o`000?ooo`3oool0H`3oool004P0oooo0P00001T0?ooo`030000003oool0oooo03h0
oooo0P0000030?ooo`030?l0003oool0oooo06<0oooo00160?ooo`800000IP3oool00`000000oooo
0?ooo`0n0?ooo`8000000`3oool00`3o0000oooo0?ooo`1S0?ooo`00A03oool2000006P0oooo00<0
00000?ooo`3oool0?`3oool200000080oooo00<0o`000?ooo`3oool0H`3oool00440oooo0`00001Z
0?ooo`800000@@3oool010000000oooo0?ooo`3o001U0?ooo`00?`3oool2000006d0oooo00<00000
0?ooo`3oool0@03oool2000000030?ooo`3o0000oooo06@0oooo000l0?ooo`<00000K`3oool00`00
0000oooo0?ooo`110?ooo`80000000<0o`000?ooo`3oool0H`3oool003T0oooo0`00001b0?ooo`03
0000003oool0oooo0480oooo00<000000?l0003oool0I03oool003L0oooo0P00001e0?ooo`030000
003oool0oooo0480oooo0P3o001U0?ooo`00=03oool3000007L0oooo00<000000?ooo`3oool0@P3o
ool00`3o000000000?ooo`1T0?ooo`002`3oool2000002<0oooo1000001j0?ooo`800000A@3oool0
0`000000oooo0?ooo`1R0?ooo`003@3oool5000001L0oooo1`00001n0?ooo`030000003oool0oooo
04D0oooo00<000000?ooo`3oool0H@3oool00180oooo200000080?ooo`L00000Q@3oool00`000000
oooo0?ooo`150?ooo`030000003oool0oooo0640oooo000J0?ooo`P00000S03oool00`000000oooo
0?ooo`160?ooo`030000003oool0oooo0600oooo002^0?ooo`030000003oool0oooo04H0oooo00<0
00000?ooo`3oool0H03oool00:h0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`1O
0?ooo`00[P3oool2000004P0oooo00<000000?ooo`3oool0G`3oool00:h0oooo00<000000?ooo`3o
ool0B03oool00`000000oooo0?ooo`1N0?ooo`00Y03oool0102jLP00000000000000L[X60?ooo`03
0000003oool0oooo04P0oooo0P00001O0?ooo`00X`3oool01P2jLP00L[[Z0?ooo`3oool0j[Yb002K
e0D0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`1M0?ooo`00Y`3oool00`3oom@0
Vg:j0?ooo`040?ooo`030000003oool0oooo04T0oooo0P00001N0?ooo`00Y`3oool00`3oe9/009_D
0?ooo`040?ooo`<00000BP3oool00`000000oooo0?ooo`1L0?ooo`00X`3oool01P3oj[X0LP000000
00000000002K0=Coo`D0oooo00<000000?ooo`3oool0BP3oool2000005d0oooo002S0?ooo`030?oZ
^P1bVm@0oooo00P0oooo00<000000?ooo`3oool0B`3oool2000005`0oooo002S0?ooo`030?oZ^P1b
Vm@0oooo00P0oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`1J0?ooo`00X`3oool0
1P3oj[X0LP00000000000000002K0=Coo`D0oooo00<000000?ooo`3oool0C03oool2000005/0oooo
002^0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool0F@3oool00:h0oooo0P00001>
0?ooo`800000FP3oool00:h0oooo00<000000?ooo`3oool0CP3oool2000005T0oooo002^0?ooo`03
0000003oool0oooo04h0oooo0P00001I0?ooo`00[P3oool00`000000oooo0?ooo`1?0?ooo`800000
F03oool00:h0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0000001G0?ooo`00[P3oool0
0`000000oooo0?ooo`1@0?ooo`800000E`3oool00:h0oooo0P00001A0?ooo`030000003oool00000
05H0oooo002^0?ooo`030000003oool0oooo0540oooo0P00001F0?ooo`00[P3oool00`000000oooo
0?ooo`1A0?ooo`030000003oool0000005D0oooo002^0?ooo`030000003oool0oooo0580oooo00<0
00000?ooo`000000E03oool00:h0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0000001D
0?ooo`00[P3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0000005<0oooo002^0?ooo`80
0000E03oool010000000oooo0?ooo`00001B0?ooo`00[P3oool00`000000oooo0?ooo`1D0?ooo`03
0000003oool000000580oooo002^0?ooo`030000003oool0oooo05@0oooo00@000000?ooo`3oool0
0000D@3oool00:h0oooo00<000000?ooo`3oool0E03oool01@000000oooo0?ooo`3oool000000500
oooo002^0?ooo`030000003oool0oooo05D0oooo00@000000?ooo`3oool00000D03oool00:h0oooo
0P00001F0?ooo`050000003oool0oooo0?ooo`000000C`3oool00:h0oooo00<000000?ooo`3oool0
EP3oool010000000oooo0?ooo`00001?0?ooo`00[P3oool00`000000oooo0?ooo`1F0?ooo`050000
003oool0oooo0?ooo`000000CP3oool009/0oooo00<0e9/00000000000000P0000001@00L[X0oooo
0?ooo`3oool0^W800080000000<009_D0?ooo`3oool0103oool00`000000oooo0?ooo`1G0?ooo`05
0000003oool0oooo0?ooo`000000C@3oool009d0oooo00<0omBK07:jjP3oool00`3oool01P3oj[X0
Vk[Z0?ooo`3oool0e9/009_Do`D0oooo00<000000?ooo`3oool0E`3oool01@000000oooo0?ooo`3o
ool0000004d0oooo002M0?ooo`030?oDV`1b^^X0oooo00<0oooo00H0e9/009_Do`3oool0oooo0?oZ
^P1bVm@50?ooo`030000003oool0oooo05P0oooo00D000000?ooo`3oool0oooo0000001<0?ooo`00
W@3oool00`3oe9/0L[[Z0?ooo`030?ooo`060=BKLP2jj_l0oooo0?ooo`3oj[X0LW:j1@3oool30000
05P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`190?ooo`00W@3oool00`3oe9/0
L[[Z0?ooo`030?ooo`060=BKLP2jj_l0oooo0?ooo`3oj[X0LW:j1@3oool00`000000oooo0?ooo`1H
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0B@3oool009d0oooo00<0omBK07:j
jP3oool00`3oool01P3DVg80^^[o0?ooo`3oool0onZj07:Ke0D0oooo00<000000?ooo`3oool0F@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04P0oooo002K0?ooo`040>ZjLP00Vm@0
omBK07:jjP@0oooo00H0omBK001b^P3oool0oooo0=BK002Ke?l50?ooo`030000003oool0oooo05T0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`180?ooo`00W03oool00`3DV`000000
07:jjP050?ooo`040>ZjLP0000000000002Ke0H0oooo00<000000?ooo`3oool0FP3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo04L0oooo002^0?ooo`030000003oool0oooo05X0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`160?ooo`00[P3oool2000005`0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`160?ooo`00[P3oool00`000000oooo0?ooo`1K
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0A@3oool00:h0oooo00<000000?oo
o`3oool0F`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo04D0oooo002^0?ooo`03
0000003oool0oooo05`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`140?ooo`00
[P3oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
@`3oool00:h0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo04<0oooo002^0?ooo`800000GP3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo0480oooo002^0?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`110?ooo`00[P3oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0@@3oool00:h0oooo00<000000?ooo`3oool0G`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0400oooo002^0?ooo`030000003oool0oooo05l0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`100?ooo`00[P3oool200000600oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0o0?ooo`00[P3oool00`000000oooo0?ooo`1P0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0?P3oool00:h0oooo00<000000?ooo`3o
ool0H03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03h0oooo002^0?ooo`030000
003oool0oooo0600oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0m0?ooo`00[P3o
ool00`000000oooo0?ooo`1P0?ooo`030?l000000000oooo00H0oooo00<000000?ooo`3oool0?@3o
ool00:h0oooo00<000000?ooo`3oool0H03oool00`3o000000000?ooo`070?ooo`030000003oool0
oooo03`0oooo002^0?ooo`800000HP3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
03/0oooo002^0?ooo`030000003oool0oooo0640oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0k0?ooo`00[P3oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0>P3oool009/0oooo00<0e9/00000000000000P0000001@00L[X0oooo0?oo
o`3oool0^W800080000000<007:j0?ooo`3oool0103oool00`000000oooo0?ooo`1R0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0>P3oool009d0oooo00<0omBK07:jjP3oool00`3o
ool01P2jLP00L[[Z0?ooo`3oool0j[Yb002Ke0D0oooo00<000000?ooo`3oool0HP3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo03T0oooo002M0?ooo`030?oDV`1b^^X0oooo00L0oooo
00<0oooD09]b^P3oool0103oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0>@3oool009d0oooo00<0omBK07:jjP3oool01`3oool00`3oe9/009_D0?oo
o`040?ooo`<00000H`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo03P0oooo002M
0?ooo`030?oDV`1b^^X0oooo00<0oooo00H0onZj07800000000000000000V`3Doona0?ooo`00W@3o
ool00`3oe9/0L[[Z0?ooo`030?ooo`030?oZ^P1bVm@0oooo0;@0oooo002K0?ooo`040>ZjLP00Vm@0
omBK07:jjP@0oooo00<0onZj07:Ke03oool0]03oool009`0oooo00<0e9/00000001b^^X0103oool0
1P3oj[X0LP00000000000000002K0=Cook40oooo003o0?oooe/0oooo0000\
\>"],
  ImageRangeCache->{{{0, 345.125}, {212.625, 0}} -> {-3.21217, -20.9778, 
  0.0230181, 0.217257}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios", "Section"],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Haz un programa para calcular ra\[IAcute]ces de una funci\[OAcute]n usando \
el m\[EAcute]todo de Newton-Raphson. El programa debe admitir como datos de \
entrada la funci\[OAcute]n y el valor inicial y debe proporcionar la soluci\
\[OAcute]n encontrada y el n\[UAcute]mero de pasos que han sido necesarios \
para calcularla. \nObservaciones. Debes poner una condici\[OAcute]n para que \
el programa acabe en un n\[UAcute]mero razonable de pasos. Esto puedes \
hacerlo introduciendo una variable que controle el n\[UAcute]mero \
m\[AAcute]ximo de iteraciones permitidas. Tambi\[EAcute]n puedes terminar el \
bucle cuando la diferencia entre dos aproximaciones consecutivas sea menor \
que una cantidad ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] > 0\)]],
  " prefijada. "
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  "Calcula, usando los algoritmos de Newton-Raphson y el de bisecci\[OAcute]n \
que has hecho antes, una soluci\[OAcute]n de la ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[ExponentialE]\^\((x\^2 + x + 1)\) - \[ExponentialE]\^\(x\^3\) - 2 = 
        0\)]],
  " en el intervalo [-0.3,1] con error menor que ",
  Cell[BoxData[
      \(TraditionalForm\`10\^\(-10\)\)]],
  ". Hazlo tambi\[EAcute]n con \"FindRoot[ ]\" y compara los resultados \
obtenidos. Puedes usar el comando \"Timing\" (consulta la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ") para saber el tiempo que emplea cada uno de ellos."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
WindowSize->{995, 628},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Elementos de programaci\[OAcute]n con Mathematica."], 
        "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Elementos de programaci\[OAcute]n con Mathematica."], 
        "Header"]}},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "b:16"->{
    Cell[57670, 1893, 624, 11, 192, "Input",
      CellTags->{"b:16", "IPM3.4.6.1"}]},
  "IPM3.4.6.1"->{
    Cell[57670, 1893, 624, 11, 192, "Input",
      CellTags->{"b:16", "IPM3.4.6.1"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"b:16", 151568, 4329},
  {"IPM3.4.6.1", 151673, 4332}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 123, 4, 69, "Title"],
Cell[1835, 55, 203, 3, 72, "Author"],

Cell[CellGroupData[{
Cell[2063, 62, 39, 0, 69, "Section"],
Cell[2105, 64, 6565, 189, 447, "Text",
  Evaluatable->False],
Cell[8673, 255, 398, 7, 165, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9108, 267, 52, 0, 69, "Section"],
Cell[9163, 269, 683, 13, 96, "Text",
  Evaluatable->False],
Cell[9849, 284, 75, 4, 78, "Input"],
Cell[9927, 290, 1529, 47, 96, "Text",
  Evaluatable->False],
Cell[11459, 339, 99, 2, 33, "Text",
  Evaluatable->False],
Cell[11561, 343, 56, 1, 59, "Input"],
Cell[11620, 346, 56, 1, 59, "Input"],
Cell[11679, 349, 999, 27, 96, "Text"],
Cell[12681, 378, 62, 2, 81, "Input"],
Cell[12746, 382, 140, 5, 33, "Text"],
Cell[12889, 389, 36, 1, 60, "Input"],
Cell[12928, 392, 443, 14, 54, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13408, 411, 57, 0, 69, "Section"],
Cell[13468, 413, 526, 13, 75, "Text"],
Cell[13997, 428, 41, 1, 60, "Input"],
Cell[14041, 431, 1322, 43, 96, "Text"],
Cell[15366, 476, 449, 12, 60, "Input"],
Cell[15818, 490, 145, 3, 60, "Input"],
Cell[15966, 495, 122, 3, 33, "Text"],
Cell[16091, 500, 268, 5, 102, "Input"],
Cell[16362, 507, 39, 1, 60, "Input"],
Cell[16404, 510, 603, 16, 77, "Text"],
Cell[17010, 528, 434, 8, 54, "Text"],
Cell[17447, 538, 171, 4, 123, "Input"],
Cell[17621, 544, 137, 3, 33, "Text"],
Cell[17761, 549, 37, 1, 60, "Input"],
Cell[17801, 552, 407, 9, 54, "Text"],
Cell[18211, 563, 39, 1, 60, "Input"],
Cell[18253, 566, 291, 7, 54, "Text"],
Cell[18547, 575, 95, 3, 123, "Input"],
Cell[18645, 580, 129, 3, 33, "Text"],
Cell[18777, 585, 320, 7, 165, "Input"],
Cell[19100, 594, 214, 4, 54, "Text"],
Cell[19317, 600, 799, 13, 207, "Input"],
Cell[20119, 615, 353, 8, 54, "Text"],
Cell[20475, 625, 44, 1, 60, "Input"],
Cell[20522, 628, 359, 8, 54, "Text"],
Cell[20884, 638, 210, 5, 123, "Input"],
Cell[21097, 645, 47, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21181, 651, 98, 2, 69, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21304, 657, 75, 2, 46, "Subsubsection",
  Evaluatable->False],
Cell[21382, 661, 378, 13, 33, "Text",
  Evaluatable->False],
Cell[21763, 676, 235, 9, 33, "Text"],
Cell[22001, 687, 1501, 55, 54, "Text"],
Cell[23505, 744, 451, 15, 33, "Text",
  Evaluatable->False],
Cell[23959, 761, 326, 8, 136, "Input"],
Cell[24288, 771, 447, 15, 33, "Text",
  Evaluatable->False],
Cell[24738, 788, 91, 4, 78, "Input"],
Cell[24832, 794, 919, 34, 33, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[25788, 833, 78, 2, 46, "Subsubsection",
  Evaluatable->False],
Cell[25869, 837, 1014, 29, 96, "Text",
  Evaluatable->False],
Cell[26886, 868, 121, 2, 33, "Text"],
Cell[27010, 872, 759, 25, 54, "Text"],
Cell[27772, 899, 94, 4, 78, "Input"],
Cell[27869, 905, 417, 15, 33, "Text",
  Evaluatable->False],
Cell[28289, 922, 100, 4, 78, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28426, 931, 76, 2, 46, "Subsubsection",
  Evaluatable->False],
Cell[28505, 935, 233, 3, 33, "Text"],
Cell[28741, 940, 130, 2, 33, "Text"],
Cell[28874, 944, 1391, 37, 228, "Text"],
Cell[30268, 983, 91, 2, 81, "Input"],
Cell[30362, 987, 289, 9, 33, "Text"],
Cell[30654, 998, 34, 1, 60, "Input"],
Cell[30691, 1001, 450, 12, 54, "Text"],
Cell[31144, 1015, 77, 1, 60, "Input"],
Cell[31224, 1018, 828, 22, 96, "Text"],
Cell[32055, 1042, 253, 4, 102, "Input"],
Cell[32311, 1048, 863, 31, 54, "Text"],
Cell[33177, 1081, 606, 16, 54, "Text"],
Cell[33786, 1099, 285, 6, 123, "Input"],
Cell[34074, 1107, 170, 5, 37, "Text"],
Cell[34247, 1114, 203, 5, 161, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34487, 1124, 78, 2, 46, "Subsubsection",
  Evaluatable->False],
Cell[34568, 1128, 1390, 47, 75, "Text"],
Cell[35961, 1177, 788, 15, 191, "Input"],
Cell[36752, 1194, 169, 5, 33, "Text"],
Cell[36924, 1201, 64, 1, 60, "Input"],
Cell[36991, 1204, 86, 1, 33, "Text"],
Cell[37080, 1207, 57, 1, 60, "Input"],
Cell[37140, 1210, 66, 0, 33, "Text"],
Cell[37209, 1212, 301, 7, 148, "Input"],
Cell[37513, 1221, 88, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37638, 1227, 30, 0, 46, "Subsubsection"],
Cell[37671, 1229, 1006, 21, 117, "Text"],
Cell[38680, 1252, 664, 11, 189, "Input"],
Cell[39347, 1265, 205, 6, 33, "Text"],
Cell[39555, 1273, 179, 8, 154, "Input"],
Cell[39737, 1283, 81, 1, 59, "Input"],
Cell[39821, 1286, 114, 3, 33, "Text"],
Cell[39938, 1291, 78, 1, 59, "Input"],
Cell[40019, 1294, 313, 4, 54, "Text"],
Cell[40335, 1300, 75, 1, 60, "Input"],
Cell[40413, 1303, 125, 3, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40575, 1311, 84, 1, 46, "Subsubsection"],
Cell[40662, 1314, 231, 6, 33, "Text",
  Evaluatable->False],
Cell[40896, 1322, 268, 6, 33, "Text",
  Evaluatable->False],
Cell[41167, 1330, 924, 27, 75, "Text",
  Evaluatable->False],
Cell[42094, 1359, 266, 6, 33, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[42397, 1370, 47, 0, 46, "Subsubsection"],
Cell[42447, 1372, 403, 14, 33, "Text",
  Evaluatable->False],
Cell[42853, 1388, 50, 1, 59, "Input"],
Cell[42906, 1391, 160, 3, 33, "Text"],
Cell[43069, 1396, 156, 8, 154, "Input"],
Cell[43228, 1406, 57, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[43322, 1412, 54, 0, 46, "Subsubsection"],
Cell[43379, 1414, 75, 0, 60, "Theorem"],
Cell[43457, 1416, 254, 9, 154, "Input"],
Cell[43714, 1427, 170, 5, 33, "Text"],
Cell[43887, 1434, 223, 9, 154, "Input"],
Cell[44113, 1445, 150, 4, 60, "Theorem"],
Cell[44266, 1451, 238, 9, 173, "Input"],
Cell[44507, 1462, 124, 3, 33, "Text"],
Cell[44634, 1467, 226, 9, 173, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[44897, 1481, 27, 0, 46, "Subsubsection"],
Cell[44927, 1483, 2470, 77, 186, "Text"],
Cell[47400, 1562, 319, 5, 54, "Text"],
Cell[47722, 1569, 129, 7, 135, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47900, 1582, 56, 0, 69, "Section"],
Cell[47959, 1584, 678, 14, 98, "Text"],
Cell[48640, 1600, 494, 8, 144, "Input"],
Cell[49137, 1610, 60, 1, 60, "Input"],
Cell[49200, 1613, 116, 2, 60, "Input"],
Cell[49319, 1617, 66, 1, 60, "Input"],
Cell[49388, 1620, 264, 7, 54, "Text"],
Cell[49655, 1629, 84, 1, 60, "Input"],
Cell[49742, 1632, 90, 1, 60, "Input"],
Cell[49835, 1635, 108, 3, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49980, 1643, 59, 0, 69, "Section"],
Cell[50042, 1645, 460, 9, 108, "Text"],
Cell[50505, 1656, 92, 1, 60, "Input"],
Cell[50600, 1659, 273, 5, 54, "Text"],
Cell[50876, 1666, 52, 1, 60, "Input"],
Cell[50931, 1669, 267, 5, 54, "Text"],
Cell[51201, 1676, 87, 1, 81, "Input"],
Cell[51291, 1679, 59, 0, 33, "Text"],
Cell[51353, 1681, 215, 5, 102, "Input"],
Cell[51571, 1688, 366, 6, 54, "Text"],
Cell[51940, 1696, 256, 6, 81, "Input"],
Cell[52199, 1704, 57, 1, 60, "Input"],
Cell[52259, 1707, 149, 3, 81, "Input"],
Cell[52411, 1712, 238, 6, 33, "Text"],
Cell[52652, 1720, 448, 8, 123, "Input"],
Cell[53103, 1730, 38, 0, 33, "Text"],
Cell[53144, 1732, 91, 2, 81, "Input"],
Cell[53238, 1736, 54, 0, 33, "Text"],
Cell[53295, 1738, 127, 2, 102, "Input"],
Cell[53425, 1742, 157, 3, 33, "Text"],
Cell[53585, 1747, 511, 11, 144, "Input"],
Cell[54099, 1760, 56, 0, 33, "Text"],
Cell[54158, 1762, 59, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[54254, 1768, 49, 0, 69, "Section"],
Cell[54306, 1770, 3361, 121, 323, "Text"],
Cell[57670, 1893, 624, 11, 192, "Input",
  CellTags->{"b:16", "IPM3.4.6.1"}],
Cell[58297, 1906, 217, 5, 33, "Text"],
Cell[58517, 1913, 133, 2, 60, "Input"],
Cell[58653, 1917, 47, 1, 60, "Input"],
Cell[58703, 1920, 904, 20, 144, "Input"],
Cell[59610, 1942, 108, 3, 33, "Text"],
Cell[59721, 1947, 387, 9, 102, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[60145, 1961, 34, 0, 67, "ExerciseMain"],

Cell[CellGroupData[{
Cell[60204, 1965, 31, 0, 48, "Exercise"],
Cell[60238, 1967, 244, 4, 54, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[60519, 1976, 31, 0, 48, "Exercise"],
Cell[60553, 1978, 806, 24, 83, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[61396, 2007, 31, 0, 48, "Exercise"],
Cell[61430, 2009, 315, 11, 33, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[61782, 2025, 31, 0, 48, "Exercise"],
Cell[61816, 2027, 592, 10, 75, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[62457, 2043, 54, 0, 69, "Section"],
Cell[62514, 2045, 4110, 121, 159, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[66661, 2171, 29, 0, 69, "Section"],

Cell[CellGroupData[{
Cell[66715, 2175, 31, 0, 48, "Exercise"],
Cell[66749, 2177, 751, 12, 125, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[67549, 2195, 51, 0, 69, "Section"],
Cell[67603, 2197, 2067, 55, 154, "Text"],

Cell[CellGroupData[{
Cell[69695, 2256, 24933, 650, 220, 5480, 405, "GraphicsData", 
"PostScript", "Graphics"],
Cell[94631, 2908, 27899, 677, 221, 5291, 393, "GraphicsData", 
"PostScript", "Graphics"],
Cell[122533, 3587, 25958, 657, 224, 5398, 399, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[148540, 4250, 29, 0, 69, "Section"],

Cell[CellGroupData[{
Cell[148594, 4254, 31, 0, 48, "Exercise"],
Cell[148628, 4256, 821, 14, 125, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[149486, 4275, 31, 0, 48, "Exercise"],
Cell[149520, 4277, 680, 15, 78, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

